/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.textures;

import cz.cuni.amis.clear2d.engine.textures.Subtexture;
import cz.cuni.amis.clear2d.engine.textures.TextureAtlas;
import cz.cuni.amis.clear2d.engine.textures.TextureAtlasXML;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class TextureAtlasFile
extends TextureAtlas {
    public TextureAtlasFile(File atlasXMLFile) {
        this.load(atlasXMLFile);
    }

    private void load(File atlasXMLFile) {
        if (atlasXMLFile == null) {
            throw new RuntimeException("atlasXMLFile == null, invalid");
        }
        TextureAtlasXML atlas = TextureAtlasXML.loadXML(atlasXMLFile);
        File sheetFile = new File(atlasXMLFile.getParentFile(), atlas.imagePath);
        try {
            this.setImage(ImageIO.read(sheetFile));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read: " + atlas.imagePath + " => " + sheetFile.getAbsoluteFile());
        }
        for (TextureAtlasXML.SubtextureXML subtextureXML : atlas.subtextures) {
            Subtexture subtexture = new Subtexture(subtextureXML.name, this, subtextureXML.x, subtextureXML.y, subtextureXML.x + subtextureXML.width, subtextureXML.y + subtextureXML.height);
            this.textures.put(subtexture.name, subtexture);
        }
    }
}

