/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.fonts;

import cz.cuni.amis.clear2d.engine.fonts.FontAtlas;
import cz.cuni.amis.clear2d.engine.fonts.FontAtlasXML;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class FontAtlasResource
extends FontAtlas {
    public FontAtlasResource(InputStream fontAtlasXMLInputStram, String fontAtlasResourcePrefix) {
        this(fontAtlasXMLInputStram, fontAtlasResourcePrefix, null);
    }

    public FontAtlasResource(InputStream fontAtlasXMLInputStram, String fontAtlasResourcePrefix, Color colorMulti) {
        this.load(fontAtlasXMLInputStram, fontAtlasResourcePrefix, colorMulti);
    }

    private void load(InputStream fontAtlasXMLInputStram, String fontAtlasResourcePrefix, Color colorMulti) {
        BufferedImage image;
        if (fontAtlasXMLInputStram == null) {
            throw new RuntimeException("atlasXMLInputStram == null, invalid");
        }
        if (fontAtlasResourcePrefix == null) {
            fontAtlasResourcePrefix = "./";
        }
        FontAtlasXML atlas = FontAtlasXML.loadXML(fontAtlasXMLInputStram);
        String resourcePath = String.valueOf(fontAtlasResourcePrefix) + "/" + atlas.imagePath;
        try {
            image = ImageIO.read(this.getClass().getClassLoader().getResourceAsStream(resourcePath));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read resource: " + atlas.imagePath + " => " + resourcePath);
        }
        StringBuilder text = new StringBuilder();
        for (String part : atlas.texts) {
            text.append(part);
        }
        this.init(image, atlas.glyphsX, atlas.glyphsY, text.toString(), colorMulti);
    }
}

