/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.controls;

import cz.cuni.amis.clear2d.engine.controls.Key;
import cz.cuni.amis.clear2d.engine.controls.KeyMap;
import cz.cuni.amis.clear2d.engine.controls.KeyState;
import cz.cuni.amis.clear2d.engine.iface.IUpdatable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Keyboard
implements KeyListener,
IUpdatable {
    private Map<Integer, KeyState> states = new HashMap<Integer, KeyState>();
    private Map<Integer, List<KeyState>> reports = new HashMap<Integer, List<KeyState>>();
    private Map<Integer, KeyState> newStates = new HashMap<Integer, KeyState>();

    public KeyState getState(int keyCode) {
        KeyState state = this.states.get(keyCode);
        if (state == null) {
            return KeyState.NONE;
        }
        return state;
    }

    public KeyState getState(String key) {
        List<Integer[]> alternatives = KeyMap.keyCodes.get(key);
        if (alternatives == null) {
            throw new RuntimeException("Key '" + key + "' not supported! Add it into the static initializer of the KeyMap class!");
        }
        KeyState result = KeyState.NONE;
        for (Integer[] keyCodes : alternatives) {
            KeyState state = null;
            Integer[] integerArray = keyCodes;
            int n = keyCodes.length;
            int n2 = 0;
            while (n2 < n) {
                Integer keyCode = integerArray[n2];
                KeyState keyCodeState = this.states.get(keyCode);
                if (state == null) {
                    state = keyCodeState;
                } else if (keyCodeState != null) {
                    state = state.andCombination[keyCodeState.id];
                }
                ++n2;
            }
            if (state == null) continue;
            result = result.orCombination[state.id];
        }
        return result;
    }

    public KeyState getState(Key key) {
        KeyState keyState = this.getState(key.key);
        if (key.ctrl) {
            keyState = keyState.andCombination[this.getState((int)17).id];
        }
        if (key.alt) {
            keyState = keyState.andCombination[this.getState((int)18).id];
        }
        if (key.shift) {
            keyState = keyState.andCombination[this.getState((int)16).id];
        }
        return keyState;
    }

    public boolean isPressed(String key) {
        KeyState state = this.getState(key);
        return state == KeyState.PRESSED || state == KeyState.HOLD;
    }

    public boolean isHeld(String key) {
        return this.getState(key) == KeyState.HOLD;
    }

    public boolean isReleased(String key) {
        KeyState state = this.getState(key);
        return state == KeyState.RELEASED || state == KeyState.NONE;
    }

    public boolean isNone(String key) {
        return this.getState(key) == KeyState.NONE;
    }

    public boolean isPressed(Key key) {
        KeyState state = this.getState(key);
        return state == KeyState.PRESSED || state == KeyState.HOLD;
    }

    public boolean isHeld(Key key) {
        return this.getState(key) == KeyState.HOLD;
    }

    public boolean isReleased(Key key) {
        KeyState state = this.getState(key);
        return state == KeyState.RELEASED || state == KeyState.NONE;
    }

    public boolean isNone(Key key) {
        return this.getState(key) == KeyState.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        Map<Integer, List<KeyState>> map = this.reports;
        synchronized (map) {
            List<KeyState> states = this.ensure(e.getKeyCode());
            states.add(KeyState.PRESSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent e) {
        Map<Integer, List<KeyState>> map = this.reports;
        synchronized (map) {
            List<KeyState> states = this.ensure(e.getKeyCode());
            states.add(KeyState.RELEASED);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private List<KeyState> ensure(int keyCode) {
        List<KeyState> states = this.reports.get(keyCode);
        if (states == null) {
            states = new ArrayList<KeyState>(2);
            this.reports.put(keyCode, states);
        }
        return states;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        int keyCode;
        this.newStates.clear();
        Map<Integer, Object> map = this.reports;
        synchronized (map) {
            for (Map.Entry<Integer, List<KeyState>> entry : this.reports.entrySet()) {
                KeyState nextState;
                keyCode = entry.getKey();
                List<KeyState> states = entry.getValue();
                if (states == null || states.size() == 0) continue;
                KeyState newState = states.remove(0);
                KeyState currState = this.states.get(keyCode);
                if (currState == null) {
                    currState = KeyState.NONE;
                }
                if (currState == (nextState = currState.next[newState.id])) continue;
                this.newStates.put(keyCode, nextState);
            }
        }
        map = this.states;
        synchronized (map) {
            for (Map.Entry<Integer, Object> entry : this.states.entrySet()) {
                KeyState nextState;
                keyCode = entry.getKey();
                KeyState currState = (KeyState)((Object)entry.getValue());
                if (this.newStates.containsKey((Object)currState) || currState == (nextState = currState.next[currState.id])) continue;
                this.newStates.put(keyCode, nextState);
            }
        }
        map = this.states;
        synchronized (map) {
            for (Map.Entry<Integer, Object> entry : this.states.entrySet()) {
                keyCode = entry.getKey();
                KeyState newState = (KeyState)((Object)entry.getValue());
                if (newState == KeyState.NONE) {
                    this.states.remove(keyCode);
                    continue;
                }
                KeyState oldState = this.states.put(keyCode, newState);
                this.stateChanged(keyCode, oldState, newState);
            }
        }
    }

    private void stateChanged(int keyCode, KeyState oldState, KeyState newState) {
    }
}

