/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.components;

import cz.cuni.amis.clear2d.engine.Camera;
import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.cuni.amis.clear2d.engine.components.CRender;
import cz.cuni.amis.clear2d.engine.iface.IDrawable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class CQuad
extends CRender
implements IDrawable {
    protected BufferedImage quadImage;
    protected Graphics2D quadGraphics;
    protected Color colorFill;
    protected Color colorOutline;

    public CQuad() {
    }

    public CQuad(SceneElement owner) {
        super(owner);
    }

    public void initQuad(int width, int height, Color colorFill, Color colorOutline) {
        this.setColor(colorFill);
        this.setOutline(colorOutline);
        this.setSize(width, height);
    }

    public void setColor(Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        if (color.equals(this.colorFill)) {
            return;
        }
        this.colorFill = color;
        if (this.quadGraphics == null) {
            return;
        }
        this.drawColorFill();
        if (this.colorOutline != null) {
            this.setOutline(this.colorOutline);
        }
    }

    protected void drawColorFill() {
        if (this.colorFill == null) {
            return;
        }
        this.quadGraphics.setColor(this.colorFill);
        this.quadGraphics.fillRect(0, 0, this.quadImage.getWidth(), this.quadImage.getHeight());
    }

    public void setOutline(Color color) {
        if (color != null && color.equals(this.colorOutline)) {
            return;
        }
        this.colorOutline = color;
        if (this.quadGraphics == null) {
            return;
        }
        this.drawColorOutline();
    }

    protected void drawColorOutline() {
        if (this.colorOutline == null) {
            this.quadGraphics.setColor(this.colorFill);
            this.quadGraphics.drawRect(0, 0, this.quadImage.getWidth() - 1, this.quadImage.getHeight() - 1);
        } else {
            this.quadGraphics.setColor(this.colorOutline);
            this.quadGraphics.drawRect(0, 0, this.quadImage.getWidth() - 1, this.quadImage.getHeight() - 1);
        }
    }

    public void setSize(int width, int height) {
        if (this.quadGraphics != null) {
            this.quadGraphics.dispose();
        }
        this.quadImage = new BufferedImage(width, height, 6);
        this.quadGraphics = this.quadImage.createGraphics();
        this.drawColorFill();
        this.drawColorOutline();
    }

    @Override
    public int getWidth() {
        return this.quadImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.quadImage.getHeight();
    }

    public Color getColor() {
        return this.colorFill;
    }

    public Color getOutline() {
        return this.colorOutline;
    }

    @Override
    public void render(Camera camera) {
        camera.draw(this.pos.x, this.pos.y, this);
    }

    @Override
    public void drawAt(Graphics2D g, float x, float y) {
        if (this.quadImage == null) {
            return;
        }
        g.drawImage((Image)this.quadImage, (int)x, (int)y, null);
    }
}

