/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine;

import cz.cuni.amis.clear2d.engine.iface.IDrawable;
import cz.cuni.amis.clear2d.engine.iface.IRender;
import cz.cuni.amis.clear2d.engine.math.Vector2;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.locks.ReentrantLock;

public class RenderTarget
implements IRender {
    public final int width;
    public final int height;
    public final float widthF;
    public final float heightF;
    private ReentrantLock lock = new ReentrantLock();
    public BufferedImage image;
    public Graphics2D graphics;
    public Color background = Color.BLACK;

    public RenderTarget(int width, int height) {
        this.width = width;
        this.height = height;
        this.widthF = width;
        this.heightF = height;
        this.image = new BufferedImage(width, height, 6);
        this.graphics = this.image.createGraphics();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void clear() {
        this.clear(this.background);
    }

    public void clear(Color color) {
        this.graphics.setColor(color);
        this.graphics.fillRect(0, 0, this.width, this.height);
    }

    @Override
    public void draw(Vector2 point, Image img) {
        if (point == null) {
            return;
        }
        this.draw(point.x, point.y, img);
    }

    @Override
    public void draw(float x, float y, Image img) {
        if (img == null) {
            return;
        }
        this.graphics.drawImage(this.image, (int)x, (int)y, img.getWidth(null), img.getHeight(null), null);
    }

    @Override
    public void draw(Vector2 point, IDrawable img) {
        if (point == null) {
            return;
        }
        this.draw(point.x, point.y, img);
    }

    @Override
    public void draw(float x, float y, IDrawable img) {
        if (img == null) {
            return;
        }
        img.drawAt(this.graphics, x, y);
    }

    public void die() {
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
        this.image = null;
    }
}

