/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine;

import cz.cuni.amis.clear2d.Clear2D;
import cz.cuni.amis.clear2d.engine.Camera;
import cz.cuni.amis.clear2d.engine.RenderTarget;
import cz.cuni.amis.clear2d.engine.iface.IUpdatable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class C2DPanel
extends JPanel
implements IUpdatable {
    private static final long serialVersionUID = -5832883655925759450L;
    private Object mutex = new Object();
    private BufferedImage image;
    private Graphics2D imageGraphics;
    private Camera camera;
    private boolean updating = false;
    private boolean repainting = false;

    public C2DPanel(int width, int height, Color background) {
        this(width, height, background, null);
    }

    public C2DPanel(int width, int height, Color background, Camera camera) {
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.setAutoscrolls(false);
        this.setLayout(null);
        this.setBackground(background);
        if (camera != null) {
            this.setCamera(camera);
        }
        this.image = new BufferedImage(width, height, 6);
        this.imageGraphics = this.image.createGraphics();
        this.addComponentListener(new PanelComponentListener());
        this.updateStart();
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        if (this.image == null || this.imageGraphics == null) {
            return;
        }
        if (this.camera == null) {
            return;
        }
        RenderTarget source = this.camera.target;
        if (source == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            source.lock();
            try {
                float dY;
                float dX;
                int sourceW = source.width;
                int sourceH = source.height;
                int targetW = this.image.getWidth();
                int targetH = this.image.getHeight();
                this.imageGraphics.setColor(this.getBackground());
                this.imageGraphics.fillRect(0, 0, targetW, targetH);
                float ratioW = (float)targetW / (float)sourceW;
                float ratioH = (float)targetH / (float)sourceH;
                if (ratioW > ratioH) {
                    ratioW = ratioH;
                    int sourceWbyRatio = (int)((float)sourceW * ratioW);
                    dX = targetW / 2 - sourceWbyRatio / 2;
                    dY = 0.0f;
                } else {
                    ratioH = ratioW;
                    int sourceHbyRatio = (int)((float)sourceH * ratioH);
                    dX = 0.0f;
                    dY = targetH / 2 - sourceHbyRatio / 2;
                }
                AffineTransform transform = AffineTransform.getScaleInstance(ratioW, ratioH);
                transform.translate(dX / ratioW, dY / ratioH);
                AffineTransformOp transformOP = new AffineTransformOp(transform, 1);
                transformOP.filter(this.camera.target.image, this.image);
            }
            finally {
                source.unlock();
            }
        }
        if (!this.repainting) {
            this.repainting = true;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = C2DPanel.this.mutex;
                    synchronized (object) {
                        C2DPanel.this.repaint();
                        C2DPanel.this.repainting = false;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Object object = this.mutex;
        synchronized (object) {
            g.drawImage(this.image, 0, 0, null);
        }
    }

    protected void visibilityChanged() {
        boolean visible = this.isVisible();
        Container parent = this.getParent();
        while (visible && parent != null) {
            visible = visible && parent.isVisible();
            parent = parent.getParent();
        }
        if (visible) {
            this.updateStart();
        } else {
            this.updateStop();
        }
    }

    protected void updateStop() {
        if (!this.updating) {
            return;
        }
        this.updating = false;
        Clear2D.engine.presentUpdate.remove(this);
    }

    protected void updateStart() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        Clear2D.engine.presentUpdate.add(this);
    }

    public void die() {
        Clear2D.engine.presentUpdate.remove(this);
    }

    protected void finalize() throws Throwable {
        try {
            Clear2D.engine.presentUpdate.remove(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    private class PanelComponentListener
    extends ComponentAdapter {
        private PanelComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (C2DPanel.this.imageGraphics != null) {
                C2DPanel.this.imageGraphics.dispose();
            }
            int w = C2DPanel.this.getWidth();
            int h = C2DPanel.this.getHeight();
            System.out.println("RESIZED: " + w + " x " + h);
            if (w <= 0 || h <= 0) {
                C2DPanel.this.image = null;
                C2DPanel.this.imageGraphics = null;
                return;
            }
            C2DPanel.this.image = new BufferedImage(C2DPanel.this.getWidth(), C2DPanel.this.getHeight(), 6);
            C2DPanel.this.imageGraphics = C2DPanel.this.image.createGraphics();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }
}

