/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.utils;

import cz.cuni.amis.experiments.IExperiment;
import cz.cuni.amis.experiments.IExperimentRunner;
import cz.cuni.amis.experiments.IExperimentSuite;
import cz.cuni.amis.experiments.ILogCentral;
import cz.cuni.amis.experiments.impl.DefaultCSVLogCentral;
import cz.cuni.amis.experiments.impl.ExperimentSuite;
import cz.cuni.amis.experiments.impl.SingleThreadExperimentSuiteRunner;
import java.io.File;
import java.util.List;

public class ExperimentUtils {
    public static <EXPERIMENT_TYPE extends IExperiment> void runExperimentsSingleThreaded(List<EXPERIMENT_TYPE> experiments, IExperimentRunner<EXPERIMENT_TYPE> runner) {
        ExperimentSuite<EXPERIMENT_TYPE> suite = new ExperimentSuite<EXPERIMENT_TYPE>("NoSuite", experiments);
        ExperimentUtils.runSuiteSingleThreaded(suite, runner);
    }

    public static <EXPERIMENT_TYPE extends IExperiment> void runSuiteSingleThreaded(IExperimentSuite<EXPERIMENT_TYPE> suite, IExperimentRunner<EXPERIMENT_TYPE> runner) {
        DefaultCSVLogCentral logCentral = new DefaultCSVLogCentral(new File(".", "logs"));
        ExperimentUtils.runSuiteSingleThreaded(suite, runner, logCentral);
    }

    public static <EXPERIMENT_TYPE extends IExperiment> void runSuiteSingleThreaded(IExperimentSuite<EXPERIMENT_TYPE> suite, IExperimentRunner<EXPERIMENT_TYPE> runner, ILogCentral logCentral) {
        SingleThreadExperimentSuiteRunner<EXPERIMENT_TYPE> suiteRunner = new SingleThreadExperimentSuiteRunner<EXPERIMENT_TYPE>(runner, logCentral);
        logCentral.init();
        suiteRunner.runExperimentSuite(suite);
        logCentral.close();
    }
}

