/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl.metrics;

import cz.cuni.amis.experiments.ILoggingHeaders;
import cz.cuni.amis.experiments.IMetric;
import cz.cuni.amis.experiments.impl.LoggingHeaders;
import cz.cuni.amis.utils.NullCheck;
import java.util.ArrayList;
import java.util.List;

public class MetricCollection {
    protected List<IMetric> metrics = new ArrayList<IMetric>();
    private boolean headersReturned = false;
    private ILoggingHeaders headers;

    public void addMetric(IMetric metric) {
        if (this.headersReturned) {
            throw new IllegalStateException("Cannot add metrics after headers have been returned");
        }
        NullCheck.check((Object)metric, (String)"metric");
        this.metrics.add(metric);
    }

    public boolean isEmpty() {
        return this.metrics.isEmpty();
    }

    public ILoggingHeaders getHeaders() {
        if (!this.headersReturned) {
            this.headersReturned = true;
            ArrayList<String> columnNames = new ArrayList<String>(this.metrics.size());
            for (IMetric metric : this.metrics) {
                columnNames.add(metric.getName());
            }
            this.headers = new LoggingHeaders(columnNames);
        }
        return this.headers;
    }

    public List<Object> getValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.metrics.size());
        for (IMetric metric : this.metrics) {
            values.add(metric.getValue());
        }
        return values;
    }

    public void reset() {
        for (IMetric metric : this.metrics) {
            metric.reset();
        }
    }

    public void stopMeasurement() {
        for (IMetric metric : this.metrics) {
            metric.stopMeasurement();
        }
    }
}

