/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.ELogType;
import cz.cuni.amis.experiments.ExperimentException;
import cz.cuni.amis.experiments.IBareLoggingOutput;
import cz.cuni.amis.experiments.ILogCentral;
import cz.cuni.amis.experiments.ILogIdentifier;
import cz.cuni.amis.experiments.ILoggingHeaders;
import cz.cuni.amis.experiments.ILoggingOutput;
import cz.cuni.amis.experiments.impl.LoggingHeadersConcatenation;
import cz.cuni.amis.utils.PairKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class DefaultLogCentral
implements ILogCentral {
    private final Logger logger = Logger.getLogger(DefaultLogCentral.class);
    protected Map<PairKey<ILogIdentifier, ELogType>, OutputData> registeredOutputs;
    private boolean active = false;

    protected void activeCheck(String opName) {
        if (!this.active) {
            throw new ExperimentException("Cannot perform " + opName + " on inactive log central");
        }
    }

    @Override
    public synchronized void close() {
        this.activeCheck("close()");
        this.active = false;
        for (OutputData outputData : this.registeredOutputs.values()) {
            if (!outputData.requestors.isEmpty()) {
                this.logger.warn((Object)("Closing output:" + outputData.output + " but there are requestors holding this output:" + outputData.requestors));
            }
            try {
                outputData.output.close();
            }
            catch (IOException ex) {
                throw new ExperimentException("Could not close log output: " + outputData.output, ex);
            }
        }
    }

    @Override
    public synchronized void flush() {
        for (OutputData outputData : this.registeredOutputs.values()) {
            try {
                outputData.output.flush();
            }
            catch (IOException ex) {
                throw new ExperimentException("Could not flush log output: " + outputData.output, ex);
            }
        }
    }

    @Override
    public synchronized void init() {
        this.registeredOutputs = new HashMap<PairKey<ILogIdentifier, ELogType>, OutputData>();
        this.active = true;
    }

    protected abstract ILoggingOutput createLoggingOutput(ILogIdentifier var1, ELogType var2) throws IOException;

    @Override
    public synchronized IBareLoggingOutput requestLoggingOutput(ILogIdentifier identifier, ELogType logType, Object requestor, ILoggingHeaders ... loggingHeaders) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Requested logging output: " + identifier + " - " + (Object)((Object)logType)));
        }
        ILoggingHeaders concatenatedHeaders = LoggingHeadersConcatenation.concatenate(loggingHeaders);
        PairKey key = new PairKey((Object)identifier, (Object)logType);
        if (!this.registeredOutputs.containsKey(key)) {
            try {
                ILoggingOutput output = this.createLoggingOutput(identifier, logType);
                output.init(concatenatedHeaders);
                OutputData data = new OutputData(output, concatenatedHeaders, requestor);
                this.registeredOutputs.put((PairKey<ILogIdentifier, ELogType>)key, data);
                return output;
            }
            catch (IOException ex) {
                throw new ExperimentException("Error creating output for log " + identifier + " - " + (Object)((Object)logType), ex);
            }
        }
        OutputData data = this.registeredOutputs.get(key);
        if (!data.headers.equals(concatenatedHeaders)) {
            throw new ExperimentException("Trying to log with different headers. Log: " + identifier + " - " + (Object)((Object)logType) + " original headers: " + data.headers + " new headers:" + concatenatedHeaders);
        }
        data.requestors.add(requestor);
        return data.output;
    }

    @Override
    public synchronized void releaseLoggingOutput(ILogIdentifier identifier, ELogType logType, Object requestor) {
        PairKey key;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Releasing logging output: " + identifier + " - " + (Object)((Object)logType)));
        }
        if (!this.registeredOutputs.containsKey(key = new PairKey((Object)identifier, (Object)logType))) {
            throw new IllegalArgumentException("Cannot release logging output that was never requested. Identifier: " + identifier + " - " + (Object)((Object)logType));
        }
        this.registeredOutputs.get((Object)key).requestors.remove(requestor);
    }

    private static class OutputData {
        protected ILoggingOutput output;
        protected Set<Object> requestors;
        protected ILoggingHeaders headers;

        public OutputData(ILoggingOutput output, ILoggingHeaders headers, Object firstRequestor) {
            this.output = output;
            this.headers = headers;
            this.requestors = new HashSet<Object>();
            this.requestors.add(firstRequestor);
        }
    }
}

