/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.ELogType;
import cz.cuni.amis.experiments.ExperimentException;
import cz.cuni.amis.experiments.ILogIdentifier;
import cz.cuni.amis.experiments.ILoggingOutput;
import cz.cuni.amis.experiments.impl.CSVLoggingOutput;
import cz.cuni.amis.experiments.impl.DefaultLogCentral;
import java.io.File;
import java.io.IOException;

public class DefaultCSVLogCentral
extends DefaultLogCentral {
    private File outputDirectory;
    private String fileNamePrefix;
    private String fileNameSuffix;

    public DefaultCSVLogCentral(File outputDirectory) {
        this(outputDirectory, "", "");
    }

    public DefaultCSVLogCentral(File outputDirectory, String fileNamePrefix, String fileNameSuffix) {
        this.outputDirectory = outputDirectory;
        this.fileNamePrefix = fileNamePrefix;
        this.fileNameSuffix = fileNameSuffix;
    }

    protected File getLogFile(ILogIdentifier identifier, ELogType logType) {
        return new File(this.outputDirectory, this.fileNamePrefix + identifier.getLogName() + this.fileNameSuffix + logType.getLogNameSuffix() + ".csv");
    }

    @Override
    protected ILoggingOutput createLoggingOutput(ILogIdentifier identifier, ELogType logType) throws IOException {
        return new CSVLoggingOutput(this.getLogFile(identifier, logType));
    }

    @Override
    public void init() {
        super.init();
        this.outputDirectory.mkdirs();
        if (!this.outputDirectory.exists()) {
            throw new ExperimentException("Could not create output directory: " + this.outputDirectory.getAbsolutePath());
        }
    }
}

