/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.ExperimentException;
import cz.cuni.amis.experiments.ILoggingHeaders;
import cz.cuni.amis.experiments.ILoggingOutput;
import cz.cuni.amis.experiments.impl.AbstractBareLoggingOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public abstract class AbstractLoggingOutput
extends AbstractBareLoggingOutput
implements ILoggingOutput {
    private final Object logQueueMutex = new Object();
    private final Object writeMutex = new Object();
    protected ILoggingHeaders headers;
    protected Queue<List<Object>> logQueue;
    private LoggingThread loggingThread;
    protected IOException iOException = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logData(List<Object> data) {
        if (data.size() != this.headers.getColumnCount()) {
            throw new ExperimentException("Tried to log " + data.size() + " columns, but the logger only has " + this.headers.getColumnCount() + " columns");
        }
        Object object = this.logQueueMutex;
        synchronized (object) {
            if (this.iOException != null) {
                throw new ExperimentException("Previous logging operation threw exception. The log is no longer usable.", this.iOException);
            }
            this.logQueue.add(data);
            this.logQueueMutex.notify();
        }
    }

    @Override
    public void init(ILoggingHeaders headers) throws IOException {
        this.headers = headers;
        this.logQueue = new ArrayDeque<List<Object>>();
        this.loggingThread = new LoggingThread();
        this.loggingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        this.loggingThread.cancel();
        Object object = this.writeMutex;
        synchronized (object) {
            this.closeInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush() throws IOException {
        Object object = this.writeMutex;
        synchronized (object) {
            this.flushInternal();
        }
    }

    protected abstract void logDataInternal(List<Object> var1) throws IOException;

    protected abstract void closeInternal() throws IOException;

    protected abstract void flushInternal() throws IOException;

    private class LoggingThread
    extends Thread {
        boolean cancelled;

        public LoggingThread() {
            super("Logging: " + AbstractLoggingOutput.this.toString());
            this.cancelled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.cancelled) {
                Object object = AbstractLoggingOutput.this.logQueueMutex;
                synchronized (object) {
                    while (AbstractLoggingOutput.this.logQueue.isEmpty()) {
                        try {
                            AbstractLoggingOutput.this.logQueueMutex.wait();
                        }
                        catch (InterruptedException ex) {
                            if (!this.cancelled) continue;
                            return;
                        }
                    }
                    try {
                        Object ex = AbstractLoggingOutput.this.writeMutex;
                        synchronized (ex) {
                            AbstractLoggingOutput.this.logDataInternal(AbstractLoggingOutput.this.logQueue.poll());
                        }
                    }
                    catch (IOException ex) {
                        AbstractLoggingOutput.this.iOException = ex;
                        return;
                    }
                }
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.interrupt();
        }
    }
}

