/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.IExperiment;
import cz.cuni.amis.experiments.IExperimentFilter;
import cz.cuni.amis.experiments.IExperimentRunner;
import cz.cuni.amis.experiments.IExperimentSuite;
import cz.cuni.amis.experiments.IExperimentSuiteRunner;
import cz.cuni.amis.experiments.ILogCentral;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractExperimentSuiteRunner<EXPERIMENT_TYPE extends IExperiment>
implements IExperimentSuiteRunner<EXPERIMENT_TYPE> {
    private final Logger logger = Logger.getLogger(AbstractExperimentSuiteRunner.class);
    protected ILogCentral logCentral;

    public AbstractExperimentSuiteRunner(ILogCentral logCentral) {
        this.logCentral = logCentral;
    }

    @Override
    public void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite, int startExperiment, int stopAfter, IExperimentFilter<EXPERIMENT_TYPE> filter) {
        for (IExperimentRunner<EXPERIMENT_TYPE> runner : this.getAllRunners()) {
            runner.init();
        }
        this.runExperimentSuiteInternal(suite, startExperiment, stopAfter, filter);
        for (IExperimentRunner<EXPERIMENT_TYPE> runner : this.getAllRunners()) {
            runner.shutdown();
        }
    }

    protected abstract List<IExperimentRunner<EXPERIMENT_TYPE>> getAllRunners();

    protected abstract void runExperimentSuiteInternal(IExperimentSuite<EXPERIMENT_TYPE> var1, int var2, int var3, IExperimentFilter<EXPERIMENT_TYPE> var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSingleExperiment(IExperimentRunner<EXPERIMENT_TYPE> runner, EXPERIMENT_TYPE experiment, ILogCentral logCentral) {
        try {
            runner.runExperiment(experiment, logCentral);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception during experiment runtime", (Throwable)ex);
        }
        finally {
            logCentral.flush();
        }
    }

    @Override
    public final void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite) {
        this.runExperimentSuite(suite, 0);
    }

    @Override
    public final void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite, int startExperiment) {
        this.runExperimentSuite(suite, startExperiment, null);
    }

    @Override
    public final void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite, IExperimentFilter<EXPERIMENT_TYPE> filter) {
        this.runExperimentSuite(suite, 0, filter);
    }

    @Override
    public final void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite, int startExperiment, int stopAfter) {
        this.runExperimentSuite(suite, startExperiment, stopAfter, null);
    }

    @Override
    public final void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite, int startExperiment, IExperimentFilter<EXPERIMENT_TYPE> filter) {
        this.runExperimentSuite(suite, startExperiment, 0, filter);
    }
}

