/*
 * Copyright (C) 2013 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments.utils;

import cz.cuni.amis.experiments.IExperiment;
import cz.cuni.amis.experiments.IExperimentRunner;
import cz.cuni.amis.experiments.IExperimentSuite;
import cz.cuni.amis.experiments.IExperimentSuiteRunner;
import cz.cuni.amis.experiments.ILogCentral;
import cz.cuni.amis.experiments.impl.DefaultCSVLogCentral;
import cz.cuni.amis.experiments.impl.ExperimentSuite;
import cz.cuni.amis.experiments.impl.SingleThreadExperimentSuiteRunner;
import java.io.File;
import java.util.List;

/**
 *
 * @author Martin Cerny
 */
public class ExperimentUtils {
    public static <EXPERIMENT_TYPE extends IExperiment> void runExperimentsSingleThreaded(List<EXPERIMENT_TYPE> experiments, IExperimentRunner<EXPERIMENT_TYPE> runner){
        IExperimentSuite<EXPERIMENT_TYPE> suite = new ExperimentSuite<EXPERIMENT_TYPE>("NoSuite", experiments);
        runSuiteSingleThreaded(suite, runner);        
    }
    
    public static <EXPERIMENT_TYPE extends IExperiment> void runSuiteSingleThreaded(IExperimentSuite<EXPERIMENT_TYPE> suite, IExperimentRunner<EXPERIMENT_TYPE> runner){
        ILogCentral logCentral = new DefaultCSVLogCentral(new File(".", "logs"));        
        runSuiteSingleThreaded(suite, runner, logCentral);
    }
    
    public static <EXPERIMENT_TYPE extends IExperiment> void runSuiteSingleThreaded(IExperimentSuite<EXPERIMENT_TYPE> suite, IExperimentRunner<EXPERIMENT_TYPE> runner, ILogCentral logCentral){
        IExperimentSuiteRunner<EXPERIMENT_TYPE> suiteRunner = new SingleThreadExperimentSuiteRunner<EXPERIMENT_TYPE>(runner, logCentral);
        logCentral.init();
        suiteRunner.runExperimentSuite(suite);
        logCentral.close();
    }
    
}
