/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.cuni.amis.experiments.impl.metrics;

/**
 *
 * @author Martin Cerny
 */
public class SynchronizedIntegerAverageMetric extends IntegerAverageMetric {

    public SynchronizedIntegerAverageMetric(String name) {
        super(name);
    }

    @Override
    public synchronized void addSample(long value) {
        super.addSample(value);
    }

    @Override
    public synchronized Double getValue() {
        return super.getValue();
    }

    @Override
    public synchronized void reset() {
        super.reset();
    }

    @Override
    public synchronized void stopMeasurement() {
        super.stopMeasurement();
    }

    
}
