/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.cuni.amis.experiments.impl.metrics;

import cz.cuni.amis.experiments.IMetric;

/**
 *
 * @author Martin Cerny
 */
public class FixedValueMetric<T> extends AbstractMetric {
    private T value;
    private boolean valueSet = false;

    public FixedValueMetric(String name) {
        super(name);
    }

    public FixedValueMetric(String name, T value) {
        super(name);
        this.value = value;
        valueSet = true;
    }

    @Override
    public T getValue() {
        if(!valueSet){
            throw new IllegalStateException("Getting metric " + getName() + " value before it was set");
        }
        return value;
    }
    
    public void setValue(T value){
        if(valueSet){
            throw new IllegalStateException("Cannot set value twice");
        } else {
            valueSet = true;
            this.value = value;
        }
    }
}
