/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.cuni.amis.experiments.impl.metrics;

/**
 *
 * @author Martin Cerny
 */
public class DoubleAverageMetric extends AbstractMetric{
    double total;
    int count;
    double noSamplesValue;
    
    public DoubleAverageMetric(String name, double noSamplesValue) {
        super(name);        
        this.noSamplesValue = noSamplesValue;
    }
    
    public DoubleAverageMetric(String name){
        this(name, Double.NaN);
    }
    
    public void addSample(double value){
        if(!active){
            return;
        }
        total += value;
        count++;
    }

    @Override
    public Double getValue() {
        if(count == 0){
            return noSamplesValue;
        }
        return total / (double)count;
    }

    @Override
    public void reset() {
        super.reset();
        count = 0;
        total = 0;
    }
    
    
    
    
    
}
