/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.IExperiment;
import cz.cuni.amis.experiments.IExperimentSuite;
import java.util.List;

/**
 * A simple implementation of experiment suite.
 * @author Martin Cerny
 */
public class ExperimentSuite<EXPERIMENT_TYPE extends IExperiment> implements IExperimentSuite<EXPERIMENT_TYPE> {

    List<EXPERIMENT_TYPE> experiments;

    String name;
    
    public ExperimentSuite(String name, List<EXPERIMENT_TYPE> experiments) {
        this.name = name;
        this.experiments = experiments;
    }
    
    
    
    @Override
    public void afterAllExperiments() {
    }

    @Override
    public void afterExperiment(EXPERIMENT_TYPE experiment) {
    }

    @Override
    public void beforeAllExperiments() {
    }

    @Override
    public void beforeExperiment(EXPERIMENT_TYPE experiment) {
    }

    @Override
    public List<EXPERIMENT_TYPE> getExperiments() {
        return experiments;
    }

    public String getName() {
        return name;
    }
    
    
}
