/*
 * Copyright (C) 2013 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.ELogType;
import cz.cuni.amis.experiments.ExperimentException;
import cz.cuni.amis.experiments.ILogIdentifier;
import cz.cuni.amis.experiments.ILoggingOutput;
import java.io.File;
import java.io.IOException;

/**
 * Log central that logs separate outputs to separate CSV files in a given directory
 * @author Martin Cerny
 */
public class DefaultCSVLogCentral extends DefaultLogCentral {

    private File outputDirectory;
    private String fileNamePrefix;
    private String fileNameSuffix;

    public DefaultCSVLogCentral(File outputDirectory) {
        this(outputDirectory, "", "");
    }

    
    
    public DefaultCSVLogCentral(File outputDirectory, String fileNamePrefix, String fileNameSuffix) {
        this.outputDirectory = outputDirectory;
        this.fileNamePrefix = fileNamePrefix;
        this.fileNameSuffix = fileNameSuffix;
    }
    
    protected File getLogFile(ILogIdentifier identifier, ELogType logType){
        return new File(outputDirectory, fileNamePrefix + identifier.getLogName() + fileNameSuffix + logType.getLogNameSuffix() + ".csv");        
    }

    @Override
    protected ILoggingOutput createLoggingOutput(ILogIdentifier identifier, ELogType logType) throws IOException {
        return new CSVLoggingOutput(getLogFile(identifier, logType));
    }
    
    

    @Override
    public void init() {
        super.init();
        outputDirectory.mkdirs();
        if (!outputDirectory.exists()) {
            throw new ExperimentException("Could not create output directory: " + outputDirectory.getAbsolutePath());
        }

    }

    
}
