/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.IExperiment;
import org.apache.log4j.Logger;

/**
 * Helper class for implementing experiments
 * @author Martin Cerny
 */
public abstract class AbstractExperiment implements IExperiment {

    protected long timeout;
    
    
    public AbstractExperiment(long timeout) {
        this.timeout = timeout;
    }
    

    @Override
    public String getDescription() {
        return toString();
    }

    @Override
    public long getTimeout() {
        return timeout;
    }
    
    

}
