/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments;

/**
 * Base interface for all per-experiment metrics
 * @author Martin Cerny
 */
public interface IMetric {
    public String getName();
    public Object getValue();
    
    /**
     * After call to this method, the value of the metric should not be allowed to change
     * until next call to reset()
     */
    public void stopMeasurement();
    public void reset();
}
