/*
 * Copyright (C) 2013 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments;

import cz.cuni.amis.experiments.IBareLoggingOutput;
import cz.cuni.amis.utils.Tuple2;
import java.util.List;

/**
 * Interface for all AiSTe components that log data. 
 * Every component may log two kinds of data:
 * <ul>
 *  <li>Runtime data - Those may logged at any time and multiple log data are provided per experiment run</li>
 *  <li>Per experiment data - only one "row" of logging data is given for a single experiment run</li>
 * </ul>
 * It is caller's responsibility to add non-component specific data to the logs (experiment number, controller name, time step, ....)
 * @author Martin Cerny
 */
public interface ILogDataProvider {

    ILogIdentifier getIdentifier();
    
    /**
     * Get the headers of runtime data that this controller logs. The return values of this method
     * must be equal (as in {@link java.lang.Object#equals(java.lang.Object) }) for all calls for
     * all instances the same controller class. The method may be called before {@link #init(cz.cuni.amis.aiste.environment.IEnvironment, cz.cuni.amis.aiste.environment.IEnvironmentRepresentation, cz.cuni.amis.aiste.environment.AgentBody, long) }.
     * @return the logging headers. If empty or null, no logs are recorderd.
     */
    ILoggingHeaders getRuntimeLoggingHeaders();

    /**
     * Must give the same headers for all instances
     * of a component class. If empty or null no logs are recorderd.
     * @return 
     */
    ILoggingHeaders getPerExperimentLoggingHeaders();
    
    /**
     * Gets per-experiment data to be logged. 
     * @return the logging data. 
     */
    List<Object> getPerExperimentLoggingData();

    /**
     * Set output for runtime logging.
     * @param loggingOutput a device to output logging data. The number of columns must correspond to that given by {@link #getRuntimeLoggingHeaders() }.
     */
    void setRuntimeLoggingOutput(IBareLoggingOutput loggingOutput);
    
}
