/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments;

/**
 * Interface for classes that may run experiment suite.
 * @author Martin Cerny
 */
public interface IExperimentSuiteRunner<EXPERIMENT_TYPE extends IExperiment> {
    public void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite);
    
    /**
     * For starting a finished suite in the middle
     * @param suite
     * @param startExperiment 
     */
    public void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite, int startExperiment);    

    /**
     * 
     * @param suite
     * @param startExperiment
     * @param stopAfter 0 to run the whole suite, otherwise the maximum number of experiments to run
     */
    public void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite, int startExperiment, int stopAfter);    

    public void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite, IExperimentFilter<EXPERIMENT_TYPE> filter);
    
    /**
     * For starting a finished suite in the middle
     * @param suite
     * @param startExperiment 
     */
    public void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite, int startExperiment, IExperimentFilter<EXPERIMENT_TYPE> filter);    

    /**
     * 
     * @param suite
     * @param startExperiment
     * @param stopAfter 0 to run the full suite
     * @param filter 
     */
    public void runExperimentSuite(IExperimentSuite<EXPERIMENT_TYPE> suite, int startExperiment, int stopAfter, IExperimentFilter<EXPERIMENT_TYPE> filter);    
}
