/*
 * Copyright (C) 2013 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments;

import java.util.List;

/**
 * A limited access interface to a logging device.
 * @author Martin Cerny
 */
public interface IBareLoggingOutput {

    /**
     * Called for every data to be logged. This method must not block the calling thread and has to be thread-safe.
     * @param data data to be logged, the size must be the same between subsequent calls
     */
    void logData(List<Object> data);
    
    /**
     * Helper function to log multiple lists of data at once
     * @param data data to be logged, the size must be the same between subsequent calls
     */
    void logData(List<Object> ... data);
    
}
