/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import org.apache.batik.util.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSupport
implements XMLConstants {
    protected XMLSupport() {
    }

    public static String getXMLLang(Element elt) {
        Attr attr = elt.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (attr != null) {
            return attr.getNodeValue();
        }
        Node n = elt.getParentNode();
        while (n != null) {
            if (n.getNodeType() == 1 && (attr = ((Element)n).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang")) != null) {
                return attr.getNodeValue();
            }
            n = n.getParentNode();
        }
        return "en";
    }

    public static String getXMLSpace(Element elt) {
        Attr attr = elt.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space");
        if (attr != null) {
            return attr.getNodeValue();
        }
        Node n = elt.getParentNode();
        while (n != null) {
            if (n.getNodeType() == 1 && (attr = ((Element)n).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space")) != null) {
                return attr.getNodeValue();
            }
            n = n.getParentNode();
        }
        return "default";
    }

    public static String defaultXMLSpace(String data) {
        StringBuffer result = new StringBuffer();
        boolean space = false;
        int i = 0;
        while (i < data.length()) {
            char c = data.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    space = false;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (space) break;
                    result.append(' ');
                    space = true;
                    break;
                }
                default: {
                    result.append(c);
                    space = false;
                }
            }
            ++i;
        }
        return result.toString().trim();
    }

    public static String preserveXMLSpace(String data) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < data.length()) {
            char c = data.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    result.append(' ');
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }
}

