/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.AbstractWeaponShooting;

public class FlakCannonShooting
extends AbstractWeaponShooting {
    protected static final WeaponPref FLAK_CANNON_PRIMARY = new WeaponPref(ItemType.FLAK_CANNON, true);
    protected static final double FLAK_CANON_SECONDARY_PROJECTILE_SPLASH_RADIUS = 400.0;
    protected static final int FLAK_CANON_SECONDARY_PROJECTILE_DAMAGE = 75;
    protected static final double FLAK_CANON_FACING_ANGLE = 25.0;

    public FlakCannonShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(agent, info, shoot, weaponry);
    }

    @Override
    protected void shoot() {
        if (!this.isWeaponReady()) {
            return;
        }
        if (!this.hasTarget()) {
            this.shoot.stopShoot();
            return;
        }
        boolean facing = this.info.isFacing(this.target, 25.0);
        boolean safeToShoot = this.isSafeToShoot(this.target);
        if (!(this.target instanceof Player)) {
            this.shootLocation(facing, safeToShoot);
            return;
        }
        Player player = (Player)this.target;
        if (!player.isVisible()) {
            this.shoot.stopShoot();
            return;
        }
        if (facing && safeToShoot) {
            this.shoot.shoot(this.weaponPref, (ILocated)player);
        } else if (facing) {
            this.shoot.shootPrimary(player);
        } else {
            this.shoot.stopShoot();
        }
    }

    private void shootLocation(boolean facing, boolean safeToShoot) {
        if (facing && safeToShoot) {
            this.shoot.shoot(this.weaponPref, this.target);
        } else {
            this.shoot.stopShoot();
        }
    }

    protected boolean isSafeToShoot(ILocated target) {
        double distance = this.info.getLocation().getDistance(target.getLocation());
        boolean safeDistance = distance > 400.0;
        boolean healty = this.info.getHealth() > 75;
        return safeDistance || healty;
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return FLAK_CANNON_PRIMARY;
    }
}

