/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.AbstractWeaponShooting;

public class BioRifleShooting
extends AbstractWeaponShooting {
    protected static final WeaponPref BIO_RIFLE_PRIMARY = new WeaponPref(ItemType.BIO_RIFLE, true);
    protected static final double BIO_RIFLE_FACING_ANGLE = 25.0;
    protected static final double BIO_RIFLE_SPLASH_RADIUS = 200.0;
    private static final int BIO_RIFLE_SPLASH_DAMAGE = 75;

    public BioRifleShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(agent, info, shoot, weaponry);
    }

    @Override
    protected void shoot() {
        boolean safe;
        if (!this.isWeaponReady()) {
            return;
        }
        if (!this.hasTarget() && this.weaponPref.isSecondary()) {
            this.chargeSecondary();
            return;
        }
        if (!this.hasTarget()) {
            this.shoot.stopShoot();
            return;
        }
        boolean facing = this.info.isFacing(this.target, 25.0);
        boolean close = this.info.getLocation().getDistance(this.target.getLocation()) < 200.0;
        boolean healthy = this.info.getHealth() > 75;
        boolean bl = safe = !close || healthy;
        if (!(this.target instanceof Player)) {
            this.shootTarget(this.target, facing, safe);
        }
        Player player = (Player)this.target;
        if (this.weaponPref.isPrimary()) {
            this.shootPrimary(player, facing, safe);
        } else {
            this.shootSecondary(player, facing, safe);
        }
    }

    protected void shootTarget(ILocated target, boolean facing, boolean safe) {
        if (facing && safe) {
            this.shoot.shootPrimary(target);
        } else if (!this.info.isSecondaryShooting().booleanValue()) {
            this.shoot.stopShoot();
        }
    }

    protected void chargeSecondary() {
        this.shoot.shootSecondary();
    }

    protected void shootSecondary(Player player, boolean facing, boolean safe) {
        if (player.isVisible() && facing && safe) {
            this.shoot.shootPrimary(player);
        } else {
            this.chargeSecondary();
        }
    }

    protected void shootPrimary(Player player, boolean facing, boolean safe) {
        if (player.isVisible() && facing && safe) {
            this.shoot.shootPrimary(this.target);
        } else if (!this.info.isSecondaryShooting().booleanValue()) {
            this.shoot.stopShoot();
        }
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return BIO_RIFLE_PRIMARY;
    }
}

