/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.collections.MyCollections;
import java.util.ArrayList;
import java.util.Collection;
import javax.vecmath.Vector3d;

public class Projectiles
extends SensorModule<UT2004Bot> {
    protected AgentInfo info;

    public Projectiles(UT2004Bot<?, ?, ?> agent, AgentInfo info) {
        super(agent);
        this.info = info;
    }

    public IncomingProjectile getNearestProjectile() {
        return (IncomingProjectile)DistanceUtils.getNearest(this.wrap(this.worldView.getAll(IncomingProjectile.class).values()), (ILocated)this.info.getLocation());
    }

    private Collection<ILocatedIncomingProjectile> wrap(Collection<IncomingProjectile> collection) {
        ArrayList<ILocatedIncomingProjectile> projection = new ArrayList<ILocatedIncomingProjectile>(collection.size());
        for (IncomingProjectile projectile : collection) {
            projection.add(new ILocatedIncomingProjectile(projectile));
        }
        return projection;
    }

    public IncomingProjectile getNearestProjectile(ILocated location) {
        return (IncomingProjectile)DistanceUtils.getNearest(this.wrap(this.worldView.getAll(IncomingProjectile.class).values()), (ILocated)location);
    }

    public IncomingProjectile getNearestProjectile(ILocated location, double maxDistance) {
        return (IncomingProjectile)DistanceUtils.getNearest(this.wrap(this.worldView.getAll(IncomingProjectile.class).values()), (ILocated)location, (double)maxDistance);
    }

    public IncomingProjectile getNearestProjectile(ILocated location, String type) {
        return (IncomingProjectile)DistanceUtils.getNearest(this.wrap(this.getProjectiles(type)), (ILocated)location);
    }

    protected Collection<IncomingProjectile> getProjectiles(final String type) {
        return MyCollections.getFiltered(this.worldView.getAll(IncomingProjectile.class).values(), (IFilter)new IFilter<IncomingProjectile>(){

            public boolean isAccepted(IncomingProjectile object) {
                return object.getType().equals(type);
            }
        });
    }

    public IncomingProjectile getNearestProjectile(ILocated location, double maxDistance, String type) {
        return (IncomingProjectile)DistanceUtils.getNearest(this.wrap(this.getProjectiles(type)), (ILocated)location, (double)maxDistance);
    }

    private static class ILocatedIncomingProjectile
    extends IncomingProjectile
    implements ILocated {
        private IncomingProjectile projectile;

        public ILocatedIncomingProjectile(IncomingProjectile projectile) {
            this.projectile = projectile;
        }

        public ILocalWorldObject getLocal() {
            return this.projectile.getLocal();
        }

        public ISharedWorldObject getShared() {
            return this.projectile.getShared();
        }

        public IStaticWorldObject getStatic() {
            return this.projectile.getStatic();
        }

        public UnrealId getId() {
            return this.projectile.getId();
        }

        public Vector3d getDirection() {
            return this.projectile.getDirection();
        }

        public Velocity getVelocity() {
            return this.projectile.getVelocity();
        }

        public double getSpeed() {
            return this.projectile.getSpeed();
        }

        public Location getOrigin() {
            return this.projectile.getOrigin();
        }

        public double getDamageRadius() {
            return this.projectile.getDamageRadius();
        }

        public String getType() {
            return this.projectile.getType();
        }

        public boolean isVisible() {
            return this.projectile.isVisible();
        }

        public double getImpactTime() {
            return this.projectile.getImpactTime();
        }

        public Location getLocation() {
            return this.projectile.getLocation();
        }
    }
}

