package nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;

/**
 *
 * <p>
 * Module to work efficiently with the sniper rifle.
 * </p>
 * 
 * <p>
 * The sniper rifle is merely a point & click weapon so this module does just
 * that. As the secondary fire mode merely zooms in, it is not used.
 * 
 * TODO: Sort out effects of secondary fire mode on accuracy.
 * </p>
 * 
 * @author mpkorstanje
 * 
 */
public class SniperRifleShooting extends LigthningGunShooting {

	protected static final WeaponPref DEFAULT_WEAPON_PREF = new WeaponPref(ItemType.SNIPER_RIFLE, true);

	public SniperRifleShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
		super(agent, info, shoot, weaponry);
	}

	@Override
	protected WeaponPref getDefaultWeaponPref() {
		return DEFAULT_WEAPON_PREF;
	}


}
