package nl.tudelft.pogamut.ut2004.agent.module.sensor;

import java.util.ArrayList;
import java.util.Collection;
import javax.vecmath.Vector3d;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.collections.MyCollections;

/**
 * Module to keep track of projectiles.
 * 
 * TODO: Horribly inefficient, use listeners.
 * TODO: Needs ILocated on {@link IncomingProjectile}.
 * 
 * @author mpkorstanje
 *
 */
@SuppressWarnings("rawtypes")
public class Projectiles extends SensorModule<UT2004Bot> {

	protected AgentInfo info;

	public Projectiles(UT2004Bot<?, ?, ?> agent, AgentInfo info) {
		super(agent);
		this.info = info;
		//incomingProjectileListener = new IncomingProjectileListener(worldView);
	}


	public IncomingProjectile getNearestProjectile() {
		return DistanceUtils.getNearest(wrap(worldView.getAll(IncomingProjectile.class).values()), info.getLocation());
	}

	private Collection<ILocatedIncomingProjectile> wrap(Collection<IncomingProjectile> collection) {
		Collection<ILocatedIncomingProjectile> projection = new ArrayList<ILocatedIncomingProjectile>(collection.size());
		for(IncomingProjectile projectile : collection){
			projection.add(new ILocatedIncomingProjectile(projectile));
		}
		
		return projection;
	}


	public IncomingProjectile getNearestProjectile(ILocated location) {
		return DistanceUtils.getNearest(wrap(worldView.getAll(IncomingProjectile.class).values()), location);
	}

	public IncomingProjectile getNearestProjectile(ILocated location, double maxDistance) {
		return DistanceUtils.getNearest(wrap(worldView.getAll(IncomingProjectile.class).values()), location, maxDistance);
	}

	public IncomingProjectile getNearestProjectile(ILocated location, String type) {
		return DistanceUtils.getNearest(wrap(getProjectiles(type)), location);
	}

	protected Collection<IncomingProjectile> getProjectiles(final String type) {
		return MyCollections.getFiltered(worldView.getAll(IncomingProjectile.class).values(), new IFilter<IncomingProjectile>() {

			@Override
			public boolean isAccepted(IncomingProjectile object) {
				return object.getType().equals(type);
			}
		});
	}


	public IncomingProjectile getNearestProjectile(ILocated location, double maxDistance, String type) {
		return DistanceUtils.getNearest(wrap(getProjectiles(type)), location, maxDistance);
	}


	private static class ILocatedIncomingProjectile extends IncomingProjectile implements ILocated {

		private IncomingProjectile projectile;


		public ILocatedIncomingProjectile(IncomingProjectile projectile) {
			this.projectile = projectile;
		}

		@Override
		public ILocalWorldObject getLocal() {
			return projectile.getLocal();
		}

		@Override
		public ISharedWorldObject getShared() {
			return projectile.getShared();
		}

		@Override
		public IStaticWorldObject getStatic() {
			return projectile.getStatic();
		}

		@Override
		public UnrealId getId() {
			return projectile.getId();
		}

	

		@Override
		public Vector3d getDirection() {
			return projectile.getDirection();
		}

	

		@Override
		public Velocity getVelocity() {
			return projectile.getVelocity();
		}

		@Override
		public double getSpeed() {
			return projectile.getSpeed();
		}

		@Override
		public Location getOrigin() {
			return projectile.getOrigin();
		}

		@Override
		public double getDamageRadius() {
			return projectile.getDamageRadius();
		}

		@Override
		public String getType() {
			return projectile.getType();
		}

		@Override
		public boolean isVisible() {
			return projectile.isVisible();
		}

		@Override
		public double getImpactTime() {
			return projectile.getImpactTime();
		}

		@Override
		public Location getLocation() {
			return projectile.getLocation();
		}

	}
	
//	/**
//	 * {@link IncomingProjectile} listener.
//	 */
//	private class IncomingProjectileListener implements IWorldEventListener<IncomingProjectile> {
//
//		/**
//		 * Constructor. Registers itself on the given WorldView object.
//		 * 
//		 * @param worldView
//		 *            WorldView object to listen to.
//		 */
//		public IncomingProjectileListener(IWorldView worldView) {
//			// FIXME: Doesn't work.
//
//			worldView.addEventListener(IncomingProjectile.class, this);
//		}
//
//		@Override
//		public void notify(IncomingProjectile event) {
//			projectiles.add(event);
//		}
//	}
//
//	/** {@link IncomingProjectile} listener */
//	IncomingProjectileListener incomingProjectileListener;

}
