package nl.tudelft.pogamut.ut2004.agent.module.shooting;

import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.collections.MyCollections;

public class GenericWeaponShootingTestController extends WeaponShootingTestController{

	
	public void logicTestWeapon(){
		
			// Get ammo
			addAmmo();
			
			// Get weapon.
			addWeapon();
			
			Player player = players.getNearestVisibleEnemy();

			if (player != null) {
				weaponShooting.shoot(player);
			}

			// Wait for navigation to be done.
			if (navigation.isNavigating()) {
				return;
			}

			// Move from point to point
			if (!info.atLocation(currentStation)) {
				navigation.navigate(currentStation);
				waitAtLocation.heat();
				return;
			}

			// Done waiting.
			if (waitAtLocation.isCool()) {
				visited.add(currentStation);
				currentStation = DistanceUtils.getNearest(visited.filter(firingRange), bot);
				if (currentStation == null) {
					visited.clear();
					currentStation = MyCollections.getRandom(visited.filter(firingRange));
				}
				return;
			}

			// Look at target with nothing else to do.
			if (player != null) {
				move.turnTo(player);
			} else if (players.canSeeEnemies()) {
				move.turnTo(players.getNearestVisibleEnemy());
			} else {
				move.turnHorizontal(30);
			}
		}



	

}
