package nl.tudelft.pogamut.ut2004.agent.module.shooting;

import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;

public class WeaponShootingParameters extends UT2004BotParameters {

	protected ItemType weapon;
	protected ItemType ammo;
	protected boolean primary;
	protected String[] firingRange;
	protected int waitAtLocationSeconds = 10;
	protected int testDurationMinutes = 10;

	public WeaponShootingParameters(ItemType weapon, ItemType ammoUnderTest, boolean firingModeUnderTest,
			String... firingRange) {
		super();
		this.weapon = weapon;
		this.ammo = ammoUnderTest;
		this.primary = firingModeUnderTest;
		this.firingRange = firingRange;
	}

	/**
	 * @return the weaponUnderTest
	 */
	public ItemType getWeapon() {
		return weapon;
	}

	/**
	 * @return the ammoUnderTest
	 */
	public ItemType getAmmo() {
		return ammo;
	}

	/**
	 * @return the firingModeUnderTest
	 */
	public boolean isPrimary() {
		return primary;
	}

	/**
	 * @return the firingRange
	 */
	public String[] getFiringRange() {
		return firingRange;
	}

	public long getWaitAtLocation() {
		return waitAtLocationSeconds;
	}

	public long getTestDuration() {
		return testDurationMinutes;
	}

	public WeaponShootingParameters setTestDurationMinutes(int testDurationMinutes) {
		this.testDurationMinutes  = testDurationMinutes;
		return this;
	}



}
