package nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon;

import nl.tudelft.pogamut.ut2004.agent.module.shooting.AbstractWeaponShooting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;

public class MinigunShooting extends AbstractWeaponShooting {

	protected static final WeaponPref DEFAULT_WEAPON_PREF = new WeaponPref(ItemType.MINIGUN, true);

	public MinigunShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
		super(agent, info, shoot, weaponry);
	}

	@Override
	protected void shoot() {

		// Wrong weapon, wait up.
		if (!isWeaponReady()) {
			return;
		}

		// No target, no shoot.
		if (!hasTarget()) {
			shoot.stopShooting();
			return;
		}

		if (!(target instanceof Player)) {
			shoot.shoot(target);
			return;
		}

		Player player = (Player) target;

		// Target not visible, hold fire.
		// Keep firing even if not facing, gives time to spin up minigun.
		if (!player.isVisible()) {
			shoot.stopShooting();
			return;
		} else {
			shoot.shoot(weaponPref, target);
		}
	}

	@Override
	protected WeaponPref getDefaultWeaponPref() {
		return DEFAULT_WEAPON_PREF;
	}

}
