package nl.tudelft.pogamut.ut2004.agent.module.shooting.util;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

/**
 * The focus point for a given location. Will self update.
 * 
 * @author mpkorstanje
 * 
 */
public final class FocusProvider implements ILocated {

	private ILocated focus;

	/**
	 * Creates a FocusProvider with a given location
	 * 
	 * @param focus
	 *            the focus for this FocusProvider
	 */
	public FocusProvider(ILocated focus) {
		super();
		this.focus = focus;
	}

	/**
	 * Creates a FocusProvider with no focus.
	 */
	public FocusProvider() {
		this(null);
	}

	/**
	 * @return the focus
	 */
	public ILocated getFocus() {
		return focus;
	}

	/**
	 * @param focus
	 *            the focus to set
	 */
	public void setFocus(ILocated focus) {		
		this.focus = focus;
	}

	/**
	 * The location this focus is focused on.
	 */
	@Override
	public Location getLocation() {
		if(focus == null){
			return null;
		}
		
		return focus.getLocation();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "FocusProvider [focus=" + focus + "]";
	}

	public void clearFocus() {
		focus = null;
	}

}
