/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.shooting.util;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;

public class FacingUtil {
    public static final double IS_FACING_ANGLE = 6.0;

    public static boolean isFacing(AgentInfo info, ILocated location) {
        return FacingUtil.isFacing(info, location, 6.0);
    }

    public static boolean isFacing(AgentInfo info, ILocated location, double angle) {
        if (info == null || location == null) {
            return false;
        }
        return FacingUtil.isFacing(info.getLocation(), info.getRotation(), location.getLocation(), angle);
    }

    public static boolean isFacing(Location origin, Rotation rotation, Location target, double angle) {
        Location agentFaceVector;
        if (origin == null || rotation == null || target == null) {
            return false;
        }
        Location directionVector = target.sub(origin).getNormalized();
        return Math.acos(directionVector.dot(agentFaceVector = rotation.toLocation().getNormalized())) <= Math.toRadians(angle);
    }

    public static boolean isFacing(Player player, ILocated location) {
        return FacingUtil.isFacing(player, location, 6.0);
    }

    public static boolean isFacing(Player player, ILocated location, double angle) {
        if (player == null || location == null) {
            return false;
        }
        return FacingUtil.isFacing(player.getLocation(), player.getRotation(), location.getLocation(), angle);
    }

    public static boolean isFacing2D(AgentInfo info, ILocated location) {
        return FacingUtil.isFacing2D(info, location, 6.0);
    }

    public static boolean isFacing2D(AgentInfo info, ILocated location, double angle) {
        if (info == null || location == null) {
            return false;
        }
        return FacingUtil.isFacing2D(info.getLocation(), info.getRotation(), location.getLocation(), angle);
    }

    public static boolean isFacing2D(Location origin, Rotation rotation, Location target, double angle) {
        Location agentFaceVector;
        if (origin == null || rotation == null || target == null) {
            return false;
        }
        Location directionVector = target.sub(origin).setZ(0.0).getNormalized();
        return Math.acos(directionVector.dot(agentFaceVector = rotation.toLocation().setZ(0.0).getNormalized())) <= Math.toRadians(angle);
    }

    public static boolean isFacing2D(Player player, ILocated location) {
        return FacingUtil.isFacing2D(player, location, 6.0);
    }

    public static boolean isFacing2D(Player player, ILocated location, double angle) {
        if (player == null || location == null) {
            return false;
        }
        return FacingUtil.isFacing2D(player.getLocation(), player.getRotation(), location.getLocation(), angle);
    }
}

