/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.AbstractWeaponShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.util.FacingUtil;

public class RocketLauncherShooting
extends AbstractWeaponShooting {
    protected static final WeaponPref ROCKET_LAUNCHER_PRIMARY = new WeaponPref(ItemType.ROCKET_LAUNCHER, true);
    protected static final double ROCKET_LAUNCHER_PROJECTILE_SPLASH_RADIUS = 250.0;
    protected static final int ROCKET_LAUNCHER_PROJECTILE_DAMAGE = 80;
    protected static final int ROCKET_LAUNCHER_THREE_PROJECTILE_DAMAGE = 240;
    protected static final double ROCKET_LAUNCHER_CHARGE_TIME_SECONDS = 1.0;
    protected Location lastLocation = null;

    public RocketLauncherShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
        super(agent, info, shoot, weaponry);
    }

    @Override
    protected void shoot() {
        if (!this.isWeaponReady()) {
            return;
        }
        if (!this.hasTarget()) {
            this.shoot.stopShooting();
            return;
        }
        boolean facing = FacingUtil.isFacing2D(this.info, this.target, 25.0);
        boolean safeToShoot = this.isSafeToShoot(this.target);
        if (!(this.target instanceof Player)) {
            this.shootLocation(facing, safeToShoot);
            return;
        }
        Player player = (Player)this.target;
        if (!player.isVisible() && this.info.isSecondaryShooting().booleanValue()) {
            this.shoot.shootPrimary((ILocated)this.lastLocation.sub(BELOW_PLAYER_OFFSET));
            this.shoot.stopShooting();
            return;
        }
        if (!player.isVisible()) {
            this.shoot.stopShooting();
            return;
        }
        this.lastLocation = player.getLocation();
        if (facing && safeToShoot) {
            if (this.weaponPref.isPrimary()) {
                this.shoot.shoot(this.weaponPref, this.target);
            } else {
                this.shoot.shootSecondaryCharged(this.target, 1.0);
            }
        } else {
            this.shoot.stopShooting();
        }
    }

    private void shootLocation(boolean facing, boolean safeToShoot) {
        if (facing && safeToShoot) {
            if (this.weaponPref.isPrimary()) {
                this.shoot.shoot(this.weaponPref, this.target);
            } else {
                this.shoot.shootSecondaryCharged(this.target, 1.0);
            }
        } else {
            this.shoot.stopShooting();
        }
    }

    protected boolean isSafeToShoot(ILocated target) {
        double distance = this.info.getLocation().getDistance(target.getLocation());
        boolean safeDistance = distance > 250.0;
        double damage = this.weaponPref.isPrimary() ? 80.0 : 240.0;
        boolean healty = (double)this.info.getHealth().intValue() > damage;
        return safeDistance || healty;
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return ROCKET_LAUNCHER_PRIMARY;
    }
}

