package nl.tudelft.pogamut.unreal.agent.module.shooting.util;

import java.util.ArrayList;
import java.util.List;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

/**
 * A list of focus providers. First provider to provide a non-null location be
 * used.
 * 
 * @author mpkorstanje
 * 
 */
public final class OrderedFocusProvider implements ILocated {

	protected List<ILocated> providers = new ArrayList<ILocated>();

	public void add(ILocated provider) {
		providers.add(provider);
	}

	@Override
	public Location getLocation() {
		for (ILocated focus : providers) {
			if (focus.getLocation() != null) {
				return focus.getLocation();
			}
		}

		return null;
	}

}
