/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.pogamut.shed.presenter.AbstractAcceptAction;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.AcceptActionFactory;
import cz.cuni.pogamut.shed.presenter.DeleteFocusedNodeAction;
import cz.cuni.pogamut.shed.presenter.FocusActionFactory;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.ShedMenuActionFactory;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedWidget;
import cz.cuni.pogamut.shed.widget.editor.ShedInplaceEditorFactory;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;

final class ChoicePresenter
extends AbstractPresenter
implements IPresenter,
PoshElementListener<CompetenceElement> {
    private final CompetenceElement choice;
    private final ShedWidget choiceWidget;

    ChoicePresenter(ShedScene scene, ShedPresenter presenter, CompetenceElement choice, ShedWidget choiceWidget) {
        super(scene, presenter);
        this.choice = choice;
        this.choiceWidget = choiceWidget;
    }

    @Override
    public void register() {
        this.choiceWidget.setPresenter(this);
        this.choice.addElementListener((PoshElementListener)this);
        this.choiceWidget.getActions().addAction(FocusActionFactory.createFocusAction());
        this.choiceWidget.getActions().addAction((WidgetAction)new DeleteFocusedNodeAction(ShedMenuActionFactory.deleteChoiceAction(this.choice)));
    }

    @Override
    public void unregister() {
        this.choice.removeElementListener((PoshElementListener)this);
        this.choiceWidget.setPresenter(null);
    }

    @Override
    public Action[] getMenuActions() {
        return new Action[]{ShedMenuActionFactory.appendSenseAction(this.choice), ShedMenuActionFactory.appendChoiceAction(this.choice), ShedMenuActionFactory.deleteChoiceAction(this.choice)};
    }

    @Override
    public AbstractAcceptAction[] getAcceptProviders() {
        return new AbstractAcceptAction[]{AcceptActionFactory.createSense2Choice(this.choice), AcceptActionFactory.createChoice2Choice(this.choice), AcceptActionFactory.createDrive2Choice(this.choice)};
    }

    public void childElementAdded(CompetenceElement parent, PoshElement child) {
    }

    public void childElementMoved(CompetenceElement parent, PoshElement child, int oldIndex, int newIndex) {
    }

    public void childElementRemoved(CompetenceElement parent, PoshElement child, int removedChildIndex) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ceName")) {
            String newChoiceName = evt.getNewValue().toString();
            this.choiceWidget.setDisplayName(newChoiceName);
        }
    }

    @Override
    public WidgetAction getEditAction() {
        return ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)ShedInplaceEditorFactory.createChoiceEditor(this.choice));
    }
}

