/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget;

import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.widget.IPresentedWidget;
import cz.cuni.pogamut.shed.widget.IShedEnvelope;
import cz.cuni.pogamut.shed.widget.ShedScene;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public abstract class AbstractShedEnvelope<T extends Widget>
extends Widget
implements IShedEnvelope<T>,
IPresentedWidget {
    private IPresenter presenter;
    protected final ShedScene scene;

    protected AbstractShedEnvelope(ShedScene scene) {
        super((Scene)scene);
        this.scene = scene;
    }

    protected abstract void updateChildrenPositions();

    @Override
    public final void add(T newWidget, int position) {
        assert (!this.getChildren().contains(newWidget));
        this.addChild(position, (Widget)newWidget);
        this.updateChildrenPositions();
    }

    public final void add(T newWidget) {
        this.add(newWidget, this.getChildren().size());
    }

    @Override
    public final void move(int absoluteIndex, T movedWidget) {
        assert (this.getChildren().contains(movedWidget));
        int oldPosition = this.getChildren().indexOf(movedWidget);
        int newPosition = absoluteIndex;
        if (newPosition < 0 || newPosition >= this.getChildren().size()) {
            throw new IndexOutOfBoundsException("New position is " + newPosition + ", but allowed range is 0.." + this.getChildren().size());
        }
        T child = this.getChild(oldPosition);
        assert (child == movedWidget);
        this.removeChild((Widget)child);
        this.addChild(newPosition, (Widget)movedWidget);
        this.updateChildrenPositions();
    }

    @Override
    public final void remove(T removedWidget) {
        assert (this.getChildren().contains(removedWidget));
        this.scene.removeBranch((Widget)removedWidget);
        this.updateChildrenPositions();
    }

    public final T getChild(int position) {
        return (T)((Widget)this.getChildren().get(position));
    }

    public final int numberOfChildren() {
        return this.getChildren().size();
    }

    @Override
    public final IPresenter getPresenter() {
        return this.presenter;
    }

    public final void setPresenter(IPresenter newPresenter) {
        this.presenter = newPresenter;
    }
}

