/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.ILapChainListener;
import cz.cuni.amis.pogamut.sposh.elements.INamedElement;
import cz.cuni.amis.pogamut.sposh.elements.IParametrizedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedWidget;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

abstract class NodePresenter<NODE extends PoshElement>
extends AbstractPresenter
implements IPresenter,
PoshElementListener<NODE>,
ILapChainListener {
    protected final TriggeredAction reference;
    protected final NODE node;
    protected final ShedWidget nodeWidget;
    protected final LapChain nodeChain;

    NodePresenter(ShedScene scene, ShedPresenter presenter, TriggeredAction reference, NODE node, ShedWidget nodeWidget, LapChain nodeChain) {
        super(scene, presenter);
        assert (reference.getName().equals(((INamedElement)node).getName()));
        this.reference = reference;
        this.node = node;
        this.nodeWidget = nodeWidget;
        this.nodeChain = nodeChain;
        this.updateWidget();
    }

    protected final void updateWidget() {
        Arguments args = this.reference.getArguments();
        FormalParameters params = ((IParametrizedElement)this.node).getParameters();
        VariableContext ctx = this.nodeChain.createContext();
        List<ShedWidget.Variable> variables = this.getDefinedVariables(ctx, params, args);
        this.nodeWidget.setPresent(variables);
        this.nodeWidget.setError(Collections.<ShedWidget.Variable>emptyList());
        List<ShedWidget.Variable> argsRepresentation = this.getOtherVariables(ctx, params, args);
        this.nodeWidget.setUnused(argsRepresentation);
        this.nodeWidget.setDisplayName(this.reference.getName());
        this.nodeWidget.revalidate();
    }

    private List<ShedWidget.Variable> getDefinedVariables(VariableContext ctx, FormalParameters params, Arguments args) {
        LinkedList<ShedWidget.Variable> variables = new LinkedList<ShedWidget.Variable>();
        for (FormalParameters.Parameter nodeParam : params) {
            String paramName = nodeParam.getName();
            Object paramValue = ctx.getValue(paramName);
            ShedWidget.Variable param = new ShedWidget.Variable(paramName, null, Result.toLap((Object)paramValue), "");
            variables.add(param);
        }
        for (Arguments.Argument arg : args) {
            String argName = arg.getParameterName();
            if (params.containsVariable(argName)) continue;
            Object argValue = ctx.getValue(argName);
            ShedWidget.Variable argRepresentation = new ShedWidget.Variable(argName, null, Result.toLap((Object)argValue), "");
            variables.add(argRepresentation);
        }
        return variables;
    }

    private List<ShedWidget.Variable> getOtherVariables(VariableContext ctx, FormalParameters params, Arguments args) {
        String[] allVars;
        LinkedList<ShedWidget.Variable> otherVars = new LinkedList<ShedWidget.Variable>();
        for (String variableName : allVars = ctx.getKeys()) {
            boolean nameIsUsed = false;
            for (Arguments.Argument arg : args) {
                if (!arg.getName().equals(variableName)) continue;
                nameIsUsed = true;
            }
            if (params.containsVariable(variableName)) {
                nameIsUsed = true;
            }
            if (nameIsUsed) continue;
            Object variableValue = ctx.getValue(variableName);
            ShedWidget.Variable variableRepresentation = new ShedWidget.Variable(variableName, null, Result.toLap((Object)variableValue), "");
            otherVars.add(variableRepresentation);
        }
        return otherVars;
    }

    public final void childElementAdded(NODE parent, PoshElement child) {
    }

    public final void childElementMoved(NODE parent, PoshElement child, int oldIndex, int newIndex) {
    }

    public final void childElementRemoved(NODE parent, PoshElement child, int removedChildIndex) {
    }

    public final void notifyLinkChanged() {
        this.updateWidget();
    }
}

