/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.shed.presenter.AbstractAcceptAction;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenterFactory;
import cz.cuni.pogamut.shed.widget.ArrowWidget;
import cz.cuni.pogamut.shed.widget.AttachmentEnvelope;
import cz.cuni.pogamut.shed.widget.DragAndDropMoveProvider;
import cz.cuni.pogamut.shed.widget.ExpandedActionEnvelope;
import cz.cuni.pogamut.shed.widget.FixedWidgetAnchor;
import cz.cuni.pogamut.shed.widget.LeveledHorizontalAnchor;
import cz.cuni.pogamut.shed.widget.RightWidgetAnchor;
import cz.cuni.pogamut.shed.widget.ShedActionsEnvelope;
import cz.cuni.pogamut.shed.widget.ShedChoicesEnvelope;
import cz.cuni.pogamut.shed.widget.ShedCollapseWidget;
import cz.cuni.pogamut.shed.widget.ShedCreationContainer;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedSenseWidget;
import cz.cuni.pogamut.shed.widget.ShedTriggerEnvelope;
import cz.cuni.pogamut.shed.widget.ShedWidget;
import cz.cuni.pogamut.shed.widget.ShedWidgetColors;
import cz.cuni.pogamut.shed.widget.SlotEnvelope;
import java.awt.Point;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.action.AcceptProvider;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Widget;

public class ShedWidgetFactory {
    protected static final int HORIZONTAL_GAP = 30;
    public static final int VERTICAL_GAP = 10;
    private final ShedScene lapScene;
    private final IPresenterFactory presenterFactory;
    private final PoshPlan plan;

    ShedWidgetFactory(ShedScene scene, PoshPlan plan, IPresenterFactory presenterFactory) {
        this.plan = plan;
        this.lapScene = scene;
        this.presenterFactory = presenterFactory;
    }

    public ShedSenseWidget createSenseWidget(LapPath sensePath) {
        Sense sense = (Sense)sensePath.traversePath(this.plan);
        ShedSenseWidget senseWidget = new ShedSenseWidget(this.lapScene, sense, ShedWidgetColors.SENSE.getColor());
        IPresenter sensePresenter = this.presenterFactory.createSensePresenter(sensePath, senseWidget);
        this.attachPresenterToWidget(senseWidget, sensePresenter, sense);
        return senseWidget;
    }

    private <TRIGGER_PARENT extends PoshElement> ShedCreationContainer<ShedTriggerEnvelope> createTriggerEnvelope(LapPath parentPath, TRIGGER_PARENT parent, Anchor firstSenseAnchor, Trigger<TRIGGER_PARENT> trigger) {
        assert (parentPath.traversePath(this.plan) == parent);
        ShedTriggerEnvelope envelope = new ShedTriggerEnvelope(this.lapScene, firstSenseAnchor);
        IPresenter triggerPresenter = this.presenterFactory.createTriggerPresenter(parentPath, envelope);
        triggerPresenter.register();
        ShedCreationContainer<ShedTriggerEnvelope> creationContainer = new ShedCreationContainer<ShedTriggerEnvelope>(envelope);
        Anchor sourceAnchor = firstSenseAnchor;
        for (int senseId = 0; senseId < trigger.size(); ++senseId) {
            LapPath sensePath = parentPath.concat(LapType.SENSE, senseId);
            ShedSenseWidget senseWidget = this.createSenseWidget(sensePath);
            envelope.add(senseWidget);
            ArrowWidget arrowWidget = new ArrowWidget(this.lapScene, sourceAnchor, senseWidget.getCommonAnchor());
            creationContainer.addArrow(arrowWidget);
            sourceAnchor = senseWidget.getCommonAnchor();
        }
        return creationContainer;
    }

    public ShedCreationContainer<AttachmentEnvelope> createAttachmentEnvelope(LapPath actionPath, TriggeredAction action) {
        assert (actionPath.traversePath(this.plan) == action);
        String actionName = action.getName();
        if (this.plan.isAP(actionName)) {
            ActionPattern actionPattern = this.plan.getAP(actionName);
            ShedWidget actionPatternWidget = new ShedWidget(this.lapScene, actionName, ShedWidgetColors.ACTION_PATTERN.getColor());
            int actionPatternId = this.plan.getActionPatternId(actionPattern);
            LapPath actionPatternPath = actionPath.concat(LapType.ACTION_PATTERN, actionPatternId);
            IPresenter apPresenter = this.presenterFactory.createActionPatternPresenter(actionPatternPath, actionPatternWidget);
            this.attachPresenterToWidget(actionPatternWidget, apPresenter, action);
            RightWidgetAnchor rightAPAnchor = new RightWidgetAnchor(actionPatternWidget);
            ShedCreationContainer<ShedActionsEnvelope> actionsContainer = this.createActionsEnvelope(actionPatternPath, rightAPAnchor);
            AttachmentEnvelope actionPatternEnvelope = new AttachmentEnvelope(this.lapScene);
            actionPatternEnvelope.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)30));
            actionPatternEnvelope.addChild(actionPatternWidget);
            actionPatternEnvelope.addChild(actionsContainer.getWidget());
            ShedCreationContainer<AttachmentEnvelope> actionPatternContainer = new ShedCreationContainer<AttachmentEnvelope>(actionPatternEnvelope);
            actionPatternContainer.addArrows(actionsContainer.getArrows());
            return actionPatternContainer;
        }
        if (this.plan.isC(actionName)) {
            Competence competence = this.plan.getC(actionName);
            ShedWidget competenceWidget = new ShedWidget(this.lapScene, competence.getName(), ShedWidgetColors.COMPETENCE.getColor());
            int competenceId = this.plan.getCompetenceId(competence);
            LapPath competencePath = actionPath.concat(LapType.COMPETENCE, competenceId);
            IPresenter competencePresenter = this.presenterFactory.createCompetencePresenter(competencePath, competenceWidget);
            this.attachPresenterToWidget(competenceWidget, competencePresenter, action);
            RightWidgetAnchor rightCompetenceAnchor = new RightWidgetAnchor(competenceWidget);
            ShedCreationContainer<ShedChoicesEnvelope> choicesContainer = this.createChoicesEnvelope(competencePath, competence, rightCompetenceAnchor);
            AttachmentEnvelope competenceEnvelope = new AttachmentEnvelope(this.lapScene);
            competenceEnvelope.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)30));
            competenceEnvelope.addChild(competenceWidget);
            competenceEnvelope.addChild(choicesContainer.getWidget());
            ShedCreationContainer<AttachmentEnvelope> competenceContainer = new ShedCreationContainer<AttachmentEnvelope>(competenceEnvelope);
            competenceContainer.addArrows(choicesContainer.getArrows());
            return competenceContainer;
        }
        ShedWidget actionWidget = new ShedWidget(this.lapScene, actionName, ShedWidgetColors.ACTION.getColor());
        IPresenter actionPresenter = this.presenterFactory.createActionPresenter(actionPath, actionWidget);
        this.attachPresenterToWidget(actionWidget, actionPresenter, action);
        AttachmentEnvelope actionAttachment = new AttachmentEnvelope(this.lapScene);
        actionAttachment.addChild(actionWidget);
        return new ShedCreationContainer<AttachmentEnvelope>(actionAttachment);
    }

    private <LAP_ELEMENT extends PoshElement> void attachPresenterToWidget(ShedWidget widget, IPresenter presenter, LAP_ELEMENT element) {
        WidgetAction editAction = presenter.getEditAction();
        if (editAction != null) {
            widget.getActions().addAction(editAction);
        }
        widget.getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)ActionFactory.createFreeMoveStrategy(), new DragAndDropMoveProvider<LAP_ELEMENT>(this.lapScene, widget, element)));
        AbstractAcceptAction[] acceptActions = presenter.getAcceptProviders();
        if (acceptActions != null) {
            for (AbstractAcceptAction acceptAction : acceptActions) {
                widget.getActions().addAction(ActionFactory.createAcceptAction((AcceptProvider)acceptAction));
            }
        }
        presenter.register();
    }

    private ShedCreationContainer<ShedChoicesEnvelope> createChoicesEnvelope(LapPath competencePath, Competence competence, Anchor sourceAnchor) {
        assert (competencePath.traversePath(this.plan) == competence);
        ShedChoicesEnvelope choicesEnvelope = new ShedChoicesEnvelope(this.lapScene, sourceAnchor);
        IPresenter choicesPresenter = this.presenterFactory.createChoicesPresenter(competencePath, choicesEnvelope);
        choicesPresenter.register();
        ShedCreationContainer<ShedChoicesEnvelope> choicesContainer = new ShedCreationContainer<ShedChoicesEnvelope>(choicesEnvelope);
        int choiceId = 0;
        for (CompetenceElement choice : competence.getChildDataNodes()) {
            LapPath choicePath = competencePath.concat(LapType.COMPETENCE_ELEMENT, choiceId++);
            ShedCreationContainer<SlotEnvelope> choiceContainer = this.createChoiceEnvelope(choicePath, choice, sourceAnchor);
            choicesEnvelope.add(choiceContainer.getWidget());
            choicesContainer.addArrows(choiceContainer.getArrows());
        }
        return choicesContainer;
    }

    private ShedCreationContainer<ShedActionsEnvelope> createActionsEnvelope(LapPath actionPatternPath, Anchor sourceAnchor) {
        ActionPattern actionPattern = (ActionPattern)actionPatternPath.traversePath(this.plan);
        ShedActionsEnvelope actionsEnvelope = new ShedActionsEnvelope(this.lapScene, sourceAnchor);
        IPresenter actionsPresenter = this.presenterFactory.createActionsPresenter(actionPatternPath, actionsEnvelope);
        actionsPresenter.register();
        ShedCreationContainer<ShedActionsEnvelope> actionsContainer = new ShedCreationContainer<ShedActionsEnvelope>(actionsEnvelope);
        int actionId = 0;
        for (TriggeredAction action : actionPattern.getActions()) {
            LapPath actionPath = actionPatternPath.concat(LapType.ACTION, actionId++);
            ShedCreationContainer<ExpandedActionEnvelope> expandedActionContainer = this.createdExpandedActionEnvelope(actionPath);
            actionsEnvelope.add(expandedActionContainer.getWidget());
            actionsContainer.addArrows(expandedActionContainer.getArrows());
            Anchor expandedActionAnchor = expandedActionContainer.getWidget().getAnchor();
            ArrowWidget arrowToParent = new ArrowWidget(this.lapScene, sourceAnchor, expandedActionAnchor);
            actionsContainer.addArrow(arrowToParent);
        }
        return actionsContainer;
    }

    ShedScene getScene() {
        return this.lapScene;
    }

    ShedCollapseWidget createDriveWidget(LapPath drivePath, DriveElement drive) {
        assert (drivePath.traversePath(this.plan) == drive);
        ShedCollapseWidget driveWidget = new ShedCollapseWidget(this.lapScene, drive.getName(), ShedWidgetColors.DRIVE.getColor());
        IPresenter drivePresenter = this.presenterFactory.createDrivePresenter(drivePath, driveWidget);
        this.attachPresenterToWidget(driveWidget, drivePresenter, drive);
        return driveWidget;
    }

    ShedCollapseWidget createChoiceWidget(LapPath choicePath, CompetenceElement choice) {
        assert (choicePath.traversePath(this.plan) == choice);
        ShedCollapseWidget choiceWidget = new ShedCollapseWidget(this.lapScene, choice.getName(), ShedWidgetColors.CHOICE.getColor());
        IPresenter choicePresenter = this.presenterFactory.createChoicePresenter(choicePath, choiceWidget);
        this.attachPresenterToWidget(choiceWidget, choicePresenter, choice);
        return choiceWidget;
    }

    public ShedCreationContainer<ExpandedActionEnvelope> createdExpandedActionEnvelope(LapPath actionPath) {
        TriggeredAction action = (TriggeredAction)actionPath.traversePath(this.plan);
        ShedCreationContainer<AttachmentEnvelope> attachmentContainer = this.createAttachmentEnvelope(actionPath, action);
        ExpandedActionEnvelope expandedAction = new ExpandedActionEnvelope(this.lapScene, attachmentContainer.getWidget());
        IPresenter expandedActionPresenter = this.presenterFactory.createExpandedActionPresenter(actionPath, expandedAction);
        expandedActionPresenter.register();
        ShedCreationContainer<ExpandedActionEnvelope> expandedActionContainer = new ShedCreationContainer<ExpandedActionEnvelope>(expandedAction);
        expandedActionContainer.addArrows(attachmentContainer.getArrows());
        return expandedActionContainer;
    }

    public ShedCreationContainer<SlotEnvelope> createDriveEnvelope(LapPath drivePath, DriveElement drive) {
        ShedCollapseWidget driveWidget = this.createDriveWidget(drivePath, drive);
        LeveledHorizontalAnchor driveAnchor = new LeveledHorizontalAnchor(driveWidget);
        ShedCreationContainer<ShedTriggerEnvelope> driveTriggerContainer = this.createTriggerEnvelope(drivePath, drive, driveAnchor, drive.getTrigger());
        LapPath driveActionPath = drivePath.concat(LapType.ACTION, 0);
        ShedCreationContainer<ExpandedActionEnvelope> expandedActionEnvelope = this.createdExpandedActionEnvelope(driveActionPath);
        SlotEnvelope driveEnvelope = new SlotEnvelope(this.lapScene, driveWidget, driveTriggerContainer.getWidget(), expandedActionEnvelope.getWidget());
        ShedCreationContainer<SlotEnvelope> driveContainer = new ShedCreationContainer<SlotEnvelope>(driveEnvelope);
        driveContainer.addArrows(driveTriggerContainer.getArrows());
        driveContainer.addArrows(expandedActionEnvelope.getArrows());
        driveContainer.addArrow(new ArrowWidget(this.lapScene, driveAnchor, expandedActionEnvelope.getWidget().getAnchor()));
        ShedWidgetFactory.addCollapseAction(driveWidget, expandedActionEnvelope);
        return driveContainer;
    }

    public ShedCreationContainer<SlotEnvelope> createChoiceEnvelope(LapPath choicePath, CompetenceElement choice, Anchor sourceAnchor) {
        ShedCollapseWidget choiceWidget = this.createChoiceWidget(choicePath, choice);
        LeveledHorizontalAnchor choiceAnchor = new LeveledHorizontalAnchor(choiceWidget);
        ShedCreationContainer<ShedTriggerEnvelope> choiceTriggerContainer = this.createTriggerEnvelope(choicePath, choice, choiceAnchor, choice.getTrigger());
        LapPath choiceActionPath = choicePath.concat(LapType.ACTION, 0);
        ShedCreationContainer<ExpandedActionEnvelope> expandedActionEnvelope = this.createdExpandedActionEnvelope(choiceActionPath);
        SlotEnvelope choiceEnvelope = new SlotEnvelope(this.lapScene, choiceWidget, choiceTriggerContainer.getWidget(), expandedActionEnvelope.getWidget());
        ShedCreationContainer<SlotEnvelope> choiceContainer = new ShedCreationContainer<SlotEnvelope>(choiceEnvelope);
        FixedWidgetAnchor leftChoiceAnchor = new FixedWidgetAnchor(choiceWidget, new Point(0, 15), Anchor.Direction.LEFT);
        ArrowWidget arrowToSource = new ArrowWidget(this.lapScene, sourceAnchor, leftChoiceAnchor);
        choiceContainer.addArrow(arrowToSource);
        choiceContainer.addArrows(choiceTriggerContainer.getArrows());
        choiceContainer.addArrows(expandedActionEnvelope.getArrows());
        choiceContainer.addArrow(new ArrowWidget(this.lapScene, choiceAnchor, expandedActionEnvelope.getWidget().getAnchor()));
        ShedWidgetFactory.addCollapseAction(choiceWidget, expandedActionEnvelope);
        return choiceContainer;
    }

    private static void addCollapseAction(ShedCollapseWidget widget, ShedCreationContainer<ExpandedActionEnvelope> envelope) {
        widget.getActions().addAction(0, (WidgetAction)new CollapseAction(envelope));
    }

    static ShedWidget createWidgetCopy(ShedWidget sourceWidget) {
        ShedWidget copy = new ShedWidget((ShedScene)sourceWidget.getScene(), sourceWidget.getDisplayName(), sourceWidget.color);
        copy.setPresent(sourceWidget.presentVars);
        copy.setError(sourceWidget.errorVars);
        copy.setUnused(sourceWidget.unusedVars);
        return copy;
    }

    private static class CollapseAction
    extends WidgetAction.Adapter {
        private final ShedCreationContainer<ExpandedActionEnvelope> envelope;

        private CollapseAction(ShedCreationContainer<ExpandedActionEnvelope> envelope) {
            this.envelope = envelope;
        }

        public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
            ShedCollapseWidget collapsableWidget = (ShedCollapseWidget)widget;
            Point localPoint = event.getPoint();
            if (event.getButton() == 1 && collapsableWidget.isCollapseArea(localPoint)) {
                boolean isEnvelopeVisible = this.envelope.getWidget().isVisible();
                collapsableWidget.setCollapsed(isEnvelopeVisible);
                this.envelope.getWidget().setVisible(!isEnvelopeVisible);
                Set<Widget> envelopeSubtree = this.getSubtreeWidgets(this.envelope.getWidget());
                ShedScene scene = (ShedScene)this.envelope.getWidget().getScene();
                List<Widget> arrows = scene.findArrows(envelopeSubtree);
                for (Widget arrow : arrows) {
                    arrow.setVisible(!isEnvelopeVisible);
                }
                scene.update();
                return WidgetAction.State.CONSUMED;
            }
            return WidgetAction.State.REJECTED;
        }

        private Set<Widget> getSubtreeWidgets(Widget subroot) {
            HashSet<Widget> allChildren = new HashSet<Widget>();
            allChildren.add(subroot);
            for (Widget child : subroot.getChildren()) {
                allChildren.addAll(this.getSubtreeWidgets(child));
            }
            return allChildren;
        }
    }
}

