/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.editor.ActionEditorProvider;
import cz.cuni.pogamut.shed.widget.editor.NodeEditorProvider;
import cz.cuni.pogamut.shed.widget.editor.SenseEditorProvider;
import java.text.MessageFormat;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ShedInplaceEditorFactory {
    public static TextFieldInplaceEditor createDriveEditor(DriveElement drive) {
        return new DriveInplaceEditor(drive);
    }

    public static TextFieldInplaceEditor createChoiceEditor(CompetenceElement choice) {
        return new ChoiceInplaceEditor(choice);
    }

    public static InplaceEditorProvider createActionEditorProvider(TriggeredAction action, ShedPresenter presenter, LapChain chain) {
        return new ActionEditorProvider(action, presenter, chain);
    }

    public static InplaceEditorProvider createSenseEditorProvider(Sense sense, ShedPresenter presenter, LapChain chain) {
        return new SenseEditorProvider(sense, presenter, chain);
    }

    public static InplaceEditorProvider createActionPatternEditor(ActionPattern actionPattern, TriggeredAction referencingAction, LapChain chain) {
        assert (actionPattern.getName().equals(referencingAction.getName()));
        return new NodeEditorProvider<ActionPattern>(actionPattern, referencingAction, chain);
    }

    public static InplaceEditorProvider createCompetenceEditor(Competence competence, TriggeredAction referencingAction, LapChain chain) {
        assert (competence.getName().equals(referencingAction.getName()));
        return new NodeEditorProvider<Competence>(competence, referencingAction, chain);
    }

    private static class ChoiceInplaceEditor
    implements TextFieldInplaceEditor {
        private final CompetenceElement choice;

        public ChoiceInplaceEditor(CompetenceElement choice) {
            this.choice = choice;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.choice.getName();
        }

        private void notify(String message) {
            NotifyDescriptor.Message infoMessage = new NotifyDescriptor.Message((Object)message, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)infoMessage);
        }

        public void setText(Widget widget, String newChoiceName) {
            try {
                this.choice.setName(newChoiceName);
            }
            catch (DuplicateNameException ex) {
                String message = MessageFormat.format("Choice name \"{0}\" already exists.", newChoiceName);
                this.notify(message);
            }
            catch (InvalidNameException ex) {
                String message = MessageFormat.format("Choice name \"{0}\" is not valid.", newChoiceName);
                this.notify(message);
            }
        }
    }

    private static class DriveInplaceEditor
    implements TextFieldInplaceEditor {
        private final DriveElement drive;

        public DriveInplaceEditor(DriveElement drive) {
            this.drive = drive;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.drive.getName();
        }

        private void notify(String message) {
            NotifyDescriptor.Message infoMessage = new NotifyDescriptor.Message((Object)message, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)infoMessage);
        }

        public void setText(Widget widget, String newDriveName) {
            try {
                this.drive.setName(newDriveName);
            }
            catch (DuplicateNameException ex) {
                String message = MessageFormat.format("Drive with name \"{0}\" is already present.", newDriveName);
                this.notify(message);
            }
            catch (InvalidNameException ex) {
                String message = MessageFormat.format("Drive name \"{0}\" is not valid.", newDriveName);
                this.notify(message);
            }
        }
    }
}

