/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.INamedElement;
import cz.cuni.amis.pogamut.sposh.elements.IParametrizedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import java.awt.event.ActionEvent;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class ShedMenuActionFactory {
    public static <T extends PoshElement> Action deleteNotPossible(final T node) {
        return new AbstractMenuAction("Unable to delete", node){

            @Override
            public void actionPerformed(ActionEvent e) {
                1.errorDialog("Unable to delete " + node.getType() + " " + ((INamedElement)node).getName());
            }
        };
    }

    public static Action deleteCompetence(Competence competence) {
        return new DeleteCompetenceAction(competence);
    }

    public static Action deleteActionPattern(ActionPattern actionPattern) {
        return new DeleteActionPatternAction(actionPattern);
    }

    public static Action createSenseAction(DriveElement drive) {
        return new AddTriggerSenseMenuAction(drive);
    }

    public static <PRIMITIVE_TYPE extends PoshElement> Action goToSourceAction(PRIMITIVE_TYPE primitive) {
        return new GoToSourceAction<PRIMITIVE_TYPE>(primitive);
    }

    public static Action appendDriveAction(DriveElement drive) {
        return new AppendDriveMenuAction(drive);
    }

    public static Action deleteDriveAction(DriveElement drive) {
        return new DeleteDriveMenuAction(drive);
    }

    public static Action appendChoiceAction(Competence competence) {
        return new AppendFirstChoiceAction(competence);
    }

    public static Action deleteChoiceAction(CompetenceElement choice) {
        return new DeleteChoiceAction(choice);
    }

    public static Action appendSenseAction(CompetenceElement choice) {
        return new AppendChoiceTriggerSenseAction(choice);
    }

    public static Action deleteSenseAction(Sense sense) {
        return new DeleteSenseAction(sense);
    }

    public static Action appendSenseAction(Sense sense) {
        return new AppendSenseAction(sense);
    }

    public static Action appendChoiceAction(CompetenceElement choice) {
        return new AppendChoiceMenuAction(choice);
    }

    public static Action appendAction(ActionPattern actionPattern, int index) {
        return new AddAPActionAction(actionPattern, index);
    }

    public static Action deleteAction(ActionPattern actionPattern, TriggeredAction action) {
        return new DeleteAPAction(actionPattern, action);
    }

    public static Action changeActionPatternParameters(ActionPattern actionPattern) {
        return new ChangeParameters<ActionPattern>("Change parameters of AP", "Parameters of action pattern", actionPattern);
    }

    public static Action changeCompetenceParameters(Competence competence) {
        return new ChangeParameters<Competence>("Change parameters of competence", "Parameters of competence", competence);
    }

    private static class ChangeParameters<NODE extends PoshElement>
    extends AbstractMenuAction<NODE> {
        private final String dialogTitle;

        public ChangeParameters(String actionName, String dialogTitle, NODE dataNode) {
            super(actionName, dataNode);
            this.dialogTitle = dialogTitle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String title = this.dialogTitle;
            String text = "Parameters:";
            NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(text, title);
            FormalParameters params = ((IParametrizedElement)this.dataNode).getParameters();
            input.setInputText("vars(" + params.toString() + ")");
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)input);
            if (result != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String userInput = input.getInputText().trim();
            try {
                FormalParameters newParams;
                if (userInput.isEmpty() || userInput.matches("^vars *\\( *\\)$")) {
                    newParams = new FormalParameters();
                } else {
                    PoshParser parser = new PoshParser((Reader)new StringReader(userInput));
                    newParams = parser.parameters();
                }
                ((IParametrizedElement)this.dataNode).setParameters(newParams);
            }
            catch (ParseException ex) {
                String msg = MessageFormat.format("Unable to parse parameters from:\n{0}\nError message: ", userInput, ex.getMessage());
                ChangeParameters.errorDialog(msg);
            }
        }
    }

    private static class DeleteAPAction
    extends AbstractMenuAction<ActionPattern> {
        private final TriggeredAction action;

        private DeleteAPAction(ActionPattern actionPattern, TriggeredAction action) {
            super("Delete action", actionPattern);
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int actionPosition = ((ActionPattern)this.dataNode).getActions().indexOf(this.action);
            TriggeredAction actionToRemove = ((ActionPattern)this.dataNode).getAction(actionPosition);
            ((ActionPattern)this.dataNode).removeAction(actionToRemove);
        }
    }

    private static class AddAPActionAction
    extends AbstractMenuAction<ActionPattern> {
        private final int index;

        public AddAPActionAction(ActionPattern actionPattern, int index) {
            super("Add action", actionPattern);
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newActionName = this.getIdentifierFromDialog("Get name of action");
            if (newActionName != null) {
                try {
                    ((ActionPattern)this.dataNode).addAction(this.index, LapElementsFactory.createAction((String)newActionName));
                }
                catch (CycleException ex) {
                    String errorMessage = MessageFormat.format("Action with name {0} would cause a cycle.", newActionName);
                    AddAPActionAction.errorDialog(errorMessage);
                }
            }
        }
    }

    private static class AppendChoiceMenuAction
    extends AbstractMenuAction<CompetenceElement> {
        private AppendChoiceMenuAction(CompetenceElement choice) {
            super("Append choice", choice);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Competence parentCompetence = (Competence)((CompetenceElement)this.dataNode).getParent();
            int anchorChoiceIndex = parentCompetence.getChildDataNodes().indexOf(this.dataNode);
            String newChoiceName = this.getIdentifierFromDialog("Name of the choice");
            if (newChoiceName == null) {
                return;
            }
            try {
                CompetenceElement newChoice = LapElementsFactory.createCompetenceElement((String)newChoiceName);
                parentCompetence.addElement(anchorChoiceIndex + 1, newChoice);
            }
            catch (DuplicateNameException ex) {
                String errorMessage = MessageFormat.format("There already is a choice with name {0}.", newChoiceName);
                AppendChoiceMenuAction.errorDialog(errorMessage);
            }
        }
    }

    private static class AppendSenseAction
    extends AbstractMenuAction<Sense> {
        private AppendSenseAction(Sense sense) {
            super("Append sense", sense);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newSenseName = this.getIdentifierFromDialog("Name of new sense");
            if (newSenseName != null) {
                Trigger trigger = ((Sense)this.dataNode).getTrigger();
                int position = trigger.indexOf((Object)this.dataNode);
                trigger.add(position + 1, LapElementsFactory.createSense((String)newSenseName));
            }
        }
    }

    private static final class DeleteSenseAction
    extends AbstractMenuAction<Sense> {
        public DeleteSenseAction(Sense sense) {
            super("Delete sense", sense);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((Sense)this.dataNode).removeFromParent();
        }
    }

    private static class AppendChoiceTriggerSenseAction
    extends AbstractMenuAction<CompetenceElement> {
        public AppendChoiceTriggerSenseAction(CompetenceElement dataNode) {
            super("Add sense", dataNode);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newSenseName = this.getIdentifierFromDialog("Name of the sense");
            if (newSenseName != null) {
                Trigger choiceTrigger = ((CompetenceElement)this.dataNode).getTrigger();
                choiceTrigger.add(0, LapElementsFactory.createSense((String)newSenseName));
            }
        }
    }

    private static class DeleteChoiceAction
    extends AbstractMenuAction<CompetenceElement> {
        public DeleteChoiceAction(CompetenceElement competenceElement) {
            super("Delete choice", competenceElement);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Competence parentCompetence = (Competence)((CompetenceElement)this.dataNode).getParent();
            parentCompetence.removeElement((CompetenceElement)this.dataNode);
        }
    }

    private static class AppendFirstChoiceAction
    extends AbstractMenuAction<Competence> {
        public AppendFirstChoiceAction(Competence dataNode) {
            super("Append choice", dataNode);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newChoiceName = this.getIdentifierFromDialog("Name of the choice");
            if (newChoiceName != null) {
                try {
                    ((Competence)this.dataNode).addElement(0, LapElementsFactory.createCompetenceElement((String)newChoiceName));
                }
                catch (DuplicateNameException ex) {
                    String errorMessage = MessageFormat.format("There already is a choice with name {0}.", newChoiceName);
                    AppendFirstChoiceAction.errorDialog(errorMessage);
                }
            }
        }
    }

    private static class DeleteDriveMenuAction
    extends AbstractMenuAction<DriveElement> {
        public DeleteDriveMenuAction(DriveElement drive) {
            super("Delete drive", drive);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DriveCollection dc = ((DriveElement)this.dataNode).getRootNode().getDriveCollection();
            dc.removeDrive((DriveElement)this.dataNode);
        }
    }

    private static class AppendDriveMenuAction
    extends AbstractMenuAction<DriveElement> {
        public AppendDriveMenuAction(DriveElement drive) {
            super("Append drive", drive);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newDriveName = this.getIdentifierFromDialog("Name of the drive");
            if (newDriveName == null) {
                return;
            }
            DriveElement newDrive = LapElementsFactory.createDriveElementNoTriggers((String)newDriveName);
            DriveCollection dc = ((DriveElement)this.dataNode).getRootNode().getDriveCollection();
            int invokerDriveIndex = dc.getDrives().indexOf(this.dataNode);
            try {
                dc.addDrive(invokerDriveIndex + 1, newDrive);
            }
            catch (DuplicateNameException ex) {
                String errorMessage = MessageFormat.format("Drive with name {0} already exists.", newDriveName);
                AppendDriveMenuAction.errorDialog(errorMessage);
            }
        }
    }

    private static class AddTriggerSenseMenuAction
    extends AbstractMenuAction<DriveElement> {
        public AddTriggerSenseMenuAction(DriveElement drive) {
            super("Add trigger", drive);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newSenseName = this.getIdentifierFromDialog("Name of the sense");
            if (newSenseName != null) {
                ((DriveElement)this.dataNode).getTrigger().add(0, LapElementsFactory.createSense((String)newSenseName));
            }
        }
    }

    private static class GoToSourceAction<PRIMITIVE_TYPE extends PoshElement>
    extends AbstractMenuAction<PRIMITIVE_TYPE> {
        public GoToSourceAction(PRIMITIVE_TYPE dataNode) {
            super("Go to source", dataNode);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String javaFilePath = ((INamedElement)this.dataNode).getName().replace('.', '/') + ".java";
            for (FileObject curRoot : GlobalPathRegistry.getDefault().getSourceRoots()) {
                EditorCookie ec;
                FileObject fileObject = curRoot.getFileObject(javaFilePath);
                if (fileObject == null) continue;
                DataObject dobj = null;
                try {
                    dobj = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (dobj == null || (ec = (EditorCookie)dobj.getCookie(EditorCookie.class)) == null) continue;
                ec.open();
            }
        }
    }

    static abstract class AbstractMenuAction<T extends PoshElement>
    extends AbstractAction {
        protected final T dataNode;

        public AbstractMenuAction(String name, T dataNode) {
            super(name);
            this.dataNode = dataNode;
        }

        protected final String getIdentifierFromDialog(String purposeTitle) {
            NotifyDescriptor.InputLine desc = new NotifyDescriptor.InputLine("Please write new identifiew. Name cannot have whitespaces in it.", purposeTitle);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            if (desc.getValue() != NotifyDescriptor.OK_OPTION) {
                return null;
            }
            if (!Pattern.compile("[a-zA-Z0-9_-]+").matcher(desc.getInputText().trim()).matches()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Identifier wasn't valid."));
                return null;
            }
            return desc.getInputText().trim();
        }

        protected static final void errorDialog(String message) {
            NotifyDescriptor.Message error = new NotifyDescriptor.Message((Object)message, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)error);
        }
    }

    private static class DeleteActionPatternAction
    extends AbstractMenuAction<ActionPattern> {
        public DeleteActionPatternAction(ActionPattern actionPattern) {
            super("Delete action pattern", actionPattern);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PoshPlan plan = ((ActionPattern)this.dataNode).getRootNode();
            plan.removeActionPattern((ActionPattern)this.dataNode);
        }
    }

    private static class DeleteCompetenceAction
    extends AbstractMenuAction<Competence> {
        public DeleteCompetenceAction(Competence dataNode) {
            super("Delete competence", dataNode);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PoshPlan plan = ((Competence)this.dataNode).getRootNode();
            plan.removeCompetence((Competence)this.dataNode);
        }
    }
}

