/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.explorer;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveData;
import cz.cuni.pogamut.posh.explorer.Explorer;
import cz.cuni.pogamut.posh.explorer.ExplorerFactory;
import cz.cuni.pogamut.posh.explorer.IExplorerActions;
import cz.cuni.pogamut.posh.explorer.IPaletteActions;
import cz.cuni.pogamut.posh.explorer.NameMapCrawler;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.openide.util.NbBundle;

public final class PalettePane
extends JPanel
implements IPaletteActions {
    private final Explorer<Competence> competencesExplorer;
    private final Explorer<ActionPattern> actionPatternsExplorer;
    private final Explorer<PrimitiveData> actionsExplorer;
    private final Explorer<PrimitiveData> sensesExplorer;
    private JPanel decriptionPanel;
    private JTabbedPane explorers;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JLabel lblDescription;
    private JTextPane txtDescription;

    public PalettePane(PoshPlan plan, Project project, ShedPresenter namePresenter) {
        this.initComponents();
        this.competencesExplorer = ExplorerFactory.createCompetenceExplorer(this, plan);
        this.explorers.addTab("Competences", this.competencesExplorer);
        this.actionPatternsExplorer = ExplorerFactory.createAPExplorer(this, plan);
        this.explorers.addTab("Action patterns", this.actionPatternsExplorer);
        if (project != null) {
            NameMapCrawler actionNameMapListener = new NameMapCrawler(namePresenter);
            this.actionsExplorer = ExplorerFactory.createActionsExplorer(this, project, actionNameMapListener);
            this.explorers.addTab("Actions", this.actionsExplorer);
            NameMapCrawler sensesNameMapListener = new NameMapCrawler(namePresenter);
            this.sensesExplorer = ExplorerFactory.createSensesExplorer(this, project, sensesNameMapListener);
            this.explorers.addTab("Senses", this.sensesExplorer);
        } else {
            this.actionsExplorer = null;
            this.sensesExplorer = null;
        }
    }

    @Override
    public void refresh() {
        this.refresh(this.competencesExplorer);
        this.refresh(this.actionPatternsExplorer);
        this.refresh(this.actionsExplorer);
        this.refresh(this.sensesExplorer);
    }

    private <T> void refresh(Explorer<T> explorer) {
        if (explorer == null) {
            return;
        }
        IExplorerActions<T> actions = explorer.getActions();
        actions.refresh(explorer);
    }

    @Override
    public void setHtmlDescription(String htmlDescription) {
        this.txtDescription.setText(htmlDescription);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.explorers = new JTabbedPane();
        this.decriptionPanel = new JPanel();
        this.lblDescription = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.txtDescription = new JTextPane();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.explorers.setPreferredSize(new Dimension(301, 300));
        this.jSplitPane1.setTopComponent(this.explorers);
        this.decriptionPanel.setPreferredSize(new Dimension(301, 300));
        this.lblDescription.setText(NbBundle.getMessage(PalettePane.class, (String)"PalettePane.lblDescription.text"));
        this.jScrollPane2.setPreferredSize(new Dimension(20, 150));
        this.txtDescription.setContentType(NbBundle.getMessage(PalettePane.class, (String)"PalettePane.txtDescription.contentType"));
        this.txtDescription.setText(NbBundle.getMessage(PalettePane.class, (String)"PalettePane.txtDescription.text"));
        this.jScrollPane2.setViewportView(this.txtDescription);
        GroupLayout decriptionPanelLayout = new GroupLayout(this.decriptionPanel);
        this.decriptionPanel.setLayout(decriptionPanelLayout);
        decriptionPanelLayout.setHorizontalGroup(decriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(decriptionPanelLayout.createSequentialGroup().addComponent(this.lblDescription).addGap(0, 341, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -1, -1, Short.MAX_VALUE));
        decriptionPanelLayout.setVerticalGroup(decriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(decriptionPanelLayout.createSequentialGroup().addComponent(this.lblDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 268, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.decriptionPanel);
        this.add((Component)this.jSplitPane1, "Center");
    }
}

