/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.openide.filesystems.FileObject;

public class EnumStructureFactory {
    private EnumStructureFactory() {
    }

    private static JavaSource getJavaSource(String enumFQN) {
        String enumResourcePath = EnumStructureFactory.convertFQNToResourcePath(enumFQN);
        FileObject fileObject = EnumStructureFactory.getFileObject(enumResourcePath);
        if (fileObject == null) {
            return null;
        }
        return JavaSource.forFileObject((FileObject)fileObject);
    }

    public static boolean isEnum(String enumFQN) {
        JavaSource js = EnumStructureFactory.getJavaSource(enumFQN);
        if (js == null) {
            return false;
        }
        try {
            ConfirmEnumTask confirmEnumTask = new ConfirmEnumTask(enumFQN);
            js.runUserActionTask((Task)confirmEnumTask, true);
            return confirmEnumTask.foundEnum();
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static List<String> getValues(String enumFQN) {
        JavaSource js = EnumStructureFactory.getJavaSource(enumFQN);
        if (js == null) {
            return null;
        }
        try {
            CollectEnumConsts collectorTask = new CollectEnumConsts();
            js.runUserActionTask((Task)collectorTask, true);
            List enumConsts = collectorTask.getCollectedConsts();
            if (enumConsts == null) {
                return null;
            }
            return enumConsts;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static FileObject getFileObject(String classResource) {
        for (FileObject curRoot : GlobalPathRegistry.getDefault().getSourceRoots()) {
            FileObject fileObject = curRoot.getFileObject(classResource);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    private static String convertFQNToResourcePath(String enumFQN) {
        return enumFQN.replace('.', '/').concat(".java");
    }

    private static class EnumCollector
    extends TreePathScanner<Void, Void> {
        private CompilationInfo info;
        private List<String> enumConsts;

        public EnumCollector(CompilationInfo info) {
            this.info = info;
        }

        public synchronized List<String> getEnumConstants() {
            return this.enumConsts;
        }

        @Override
        public synchronized Void visitClass(ClassTree t, Void v) {
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el == null) {
                return null;
            }
            TypeElement te = (TypeElement)el;
            List<VariableElement> fields = ElementFilter.fieldsIn(te.getEnclosedElements());
            this.enumConsts = new LinkedList<String>();
            for (VariableElement field : fields) {
                if (field.getKind() != ElementKind.ENUM_CONSTANT) continue;
                String name = field.getSimpleName().toString();
                this.enumConsts.add(name);
            }
            return null;
        }
    }

    private static class CollectEnumConsts
    implements Task<CompilationController> {
        private EnumCollector collector;

        private CollectEnumConsts() {
        }

        public void run(CompilationController parameter) throws IOException {
            parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            this.collector = new EnumCollector((CompilationInfo)parameter);
            this.collector.scan(parameter.getCompilationUnit(), null);
        }

        private List<String> getCollectedConsts() {
            return this.collector.getEnumConstants();
        }
    }

    private static class ConfirmEnumTask
    implements Task<CompilationController> {
        private final String enumFQN;
        private boolean foundEnum = false;

        public ConfirmEnumTask(String enumFQN) {
            this.enumFQN = enumFQN;
        }

        public void run(CompilationController parameter) throws Exception {
            parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            List tles = parameter.getTopLevelElements();
            for (TypeElement tle : tles) {
                ElementKind kind = tle.getKind();
                boolean isEnum = kind == ElementKind.ENUM;
                boolean hasSameName = this.enumFQN.equals(tle.getQualifiedName().toString());
                if (!isEnum || !hasSameName) continue;
                this.foundEnum = true;
                break;
            }
        }

        private boolean foundEnum() {
            return this.foundEnum;
        }
    }
}

