/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

final class AddArgumentAction
implements ActionListener {
    private final JTable argumentsTable;
    private final ArgumentsTableModel argumentsModel;
    private final InplaceEditorProvider.EditorController controller;
    private final LapChain chain;

    AddArgumentAction(JTable argumentsTable, ArgumentsTableModel argumentsModel, InplaceEditorProvider.EditorController controller, LapChain chain) {
        this.argumentsTable = argumentsTable;
        this.argumentsModel = argumentsModel;
        this.controller = controller;
        this.chain = chain;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        String title = "New argument";
        NotifyDescriptor.InputLine argumentNameDialog = new NotifyDescriptor.InputLine("Specify name of the argument (must start with $)", title);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)argumentNameDialog) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String argumentName = argumentNameDialog.getInputText().trim();
        if (!Result.isVariableName((String)argumentName)) {
            NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message((Object)"Wrong name of argument.\nName must match regular expression: \\$[a-zA-Z]([_\\-a-zA-Z0-9])*");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)paramNameWrong);
            return;
        }
        NotifyDescriptor.InputLine valueInput = new NotifyDescriptor.InputLine("Specify the value of the argument(String \"Hello?\", integer 125, double 1.57, nil or other variable $var", title);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)valueInput) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        int addIndex = this.getAddIndex();
        String defaultValueString = valueInput.getInputText().trim();
        if (Result.isVariableName((String)defaultValueString)) {
            String variableName = defaultValueString;
            VariableContext ctx = this.chain.subchain(0, this.chain.size() - 1).createContext();
            if (!ctx.hasVariable(variableName)) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message((Object)("Variable " + variableName + " is not in defined in the node."));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)paramNameWrong);
                return;
            }
            this.argumentsModel.addVariableArgument(addIndex, argumentName, variableName);
        } else {
            Object value;
            try {
                value = Result.parseValue((String)defaultValueString);
            }
            catch (ParseException ex) {
                NotifyDescriptor.Message paramNameWrong = new NotifyDescriptor.Message((Object)("Wrong value of argument.\nParsing error: " + ex.getMessage()));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)paramNameWrong);
                return;
            }
            this.argumentsModel.addArgument(addIndex, argumentName, value);
        }
        this.controller.notifyEditorComponentBoundsChanged();
    }

    private int getAddIndex() {
        int addIndex = this.argumentsTable.getSelectedRow();
        if (addIndex == -1) {
            addIndex = this.argumentsTable.getRowCount();
        }
        return addIndex;
    }
}

