/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget;

import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.pogamut.posh.explorer.IPaletteActions;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ArrowWidget;
import cz.cuni.pogamut.shed.widget.FixedWidgetAnchor;
import cz.cuni.pogamut.shed.widget.IPresentedWidget;
import cz.cuni.pogamut.shed.widget.ShedDrivesEnvelope;
import cz.cuni.pogamut.shed.widget.ShedTriggerEnvelope;
import cz.cuni.pogamut.shed.widget.ShedWidget;
import cz.cuni.pogamut.shed.widget.ShedWidgetFactory;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Exceptions;

public class ShedScene
extends Scene {
    private final ShedPresenter presenter;
    private final LayerWidget backgroundLayer = this.createBackground();
    private final LayerWidget widgetLayer;
    private final LayerWidget connectionLayer;
    private final LayerWidget dragAndDropLayer;
    private final Widget dcPadding;
    private final Anchor dcAnchor;
    private final Widget dcEnvelope;
    private final ShedTriggerEnvelope goalEnvelope;
    private final ShedDrivesEnvelope drivesEnvelope;
    private ShedWidgetFactory widgetFactory;
    private IPaletteActions paletteActions;
    int loop = 0;

    public ShedScene(PoshPlan plan) {
        this.addChild((Widget)this.backgroundLayer);
        this.widgetLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.widgetLayer);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.connectionLayer);
        this.dragAndDropLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.dragAndDropLayer);
        this.widgetLayer.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)0));
        this.dcPadding = new Widget((Scene)this);
        this.dcPadding.setMinimumSize(new Dimension(30, 1));
        this.widgetLayer.addChild(this.dcPadding);
        this.dcAnchor = new FixedWidgetAnchor(this.dcPadding, new Point(0, 0), Anchor.Direction.BOTTOM);
        this.dcEnvelope = new Widget((Scene)this);
        this.dcEnvelope.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)10));
        this.widgetLayer.addChild(this.dcEnvelope);
        this.goalEnvelope = new ShedTriggerEnvelope(this, this.dcAnchor);
        this.dcEnvelope.addChild((Widget)this.goalEnvelope);
        this.drivesEnvelope = new ShedDrivesEnvelope(this);
        this.dcEnvelope.addChild((Widget)this.drivesEnvelope);
        this.presenter = new ShedPresenter(this, plan);
        this.getActions().addAction(ActionFactory.createWheelPanAction());
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(ActionFactory.createZoomAction((double)1.25, (boolean)false));
    }

    private LayerWidget createBackground() {
        return new LayerWidget((Scene)this);
    }

    public ShedPresenter getPresenter() {
        return this.presenter;
    }

    public ShedTriggerEnvelope getGoalEnvelope() {
        return this.goalEnvelope;
    }

    public ShedDrivesEnvelope getDrivesEnvelope() {
        return this.drivesEnvelope;
    }

    public Anchor getRootAnchor() {
        return this.dcAnchor;
    }

    public void setPaletteActions(IPaletteActions paletteActions) {
        this.paletteActions = paletteActions;
    }

    public IPaletteActions getPaletteActions() {
        return this.paletteActions;
    }

    public final void removeBranch(Widget removedBranchRoot) {
        Widget[] children;
        for (Widget child : children = removedBranchRoot.getChildren().toArray(new Widget[0])) {
            this.removeBranch(child);
        }
        List<Widget> widgetsToRemove = this.findArrows(removedBranchRoot);
        this.connectionLayer.removeChildren(widgetsToRemove);
        if (removedBranchRoot instanceof IPresentedWidget) {
            IPresentedWidget presentedWidget = (IPresentedWidget)removedBranchRoot;
            IPresenter branchRootPresenter = presentedWidget.getPresenter();
            branchRootPresenter.unregister();
        }
        Widget rootParentWidget = removedBranchRoot.getParentWidget();
        rootParentWidget.removeChild(removedBranchRoot);
    }

    public List<Widget> findArrows(Widget arrowEndpointWidget) {
        return this.findArrows(Collections.singleton(arrowEndpointWidget));
    }

    List<Widget> findArrows(Set<Widget> arrowEndpointWidgets) {
        LinkedList<Widget> foundArrows = new LinkedList<Widget>();
        for (Widget arrow : this.connectionLayer.getChildren()) {
            ArrowWidget arrowWidget = (ArrowWidget)arrow;
            Anchor sourceAnchor = arrowWidget.getSourceAnchor();
            Widget sourceWidget = sourceAnchor.getRelatedWidget();
            Anchor targetAnchor = arrowWidget.getTargetAnchor();
            Widget targetWidget = targetAnchor.getRelatedWidget();
            if (!arrowEndpointWidgets.contains(targetWidget) && !arrowEndpointWidgets.contains(sourceWidget)) continue;
            foundArrows.add(arrow);
        }
        return foundArrows;
    }

    public ShedWidget findShedWidget(Point scenePoint) {
        for (Widget widget : this.widgetLayer.getChildren()) {
            ShedWidget foundWidget = this.findShedWidget(widget, scenePoint);
            if (foundWidget == null) continue;
            return foundWidget;
        }
        return null;
    }

    private ShedWidget findShedWidget(Widget searchedEnvelope, Point scenePoint) {
        for (Widget searchedEnvelopeChild : searchedEnvelope.getChildren()) {
            ShedWidget foundWidget = this.findShedWidget(searchedEnvelopeChild, scenePoint);
            if (foundWidget == null) continue;
            return foundWidget;
        }
        Rectangle localSearchedBounds = searchedEnvelope.getBounds();
        Rectangle sceneSearchedBounds = searchedEnvelope.convertLocalToScene(localSearchedBounds);
        if (sceneSearchedBounds.contains(scenePoint) && searchedEnvelope instanceof ShedWidget) {
            return (ShedWidget)searchedEnvelope;
        }
        return null;
    }

    public final void addArrow(Anchor sourceAnchor, Anchor targetAnchor) {
        ArrowWidget arrowWidget = new ArrowWidget(this, sourceAnchor, targetAnchor);
        this.connectionLayer.addChild((Widget)arrowWidget);
    }

    public void addArrows(Set<ArrowWidget> arrows) {
        for (ArrowWidget arrow : arrows) {
            this.connectionLayer.addChild((Widget)arrow);
        }
    }

    public Set<ArrowWidget> findArrows(Anchor sourceAnchor, Anchor targetAnchor) {
        HashSet<ArrowWidget> foundArrows = new HashSet<ArrowWidget>();
        for (Widget widget : this.connectionLayer.getChildren()) {
            ArrowWidget arrow = (ArrowWidget)widget;
            if (arrow.getSourceAnchor() != sourceAnchor || arrow.getTargetAnchor() != targetAnchor) continue;
            foundArrows.add(arrow);
        }
        return foundArrows;
    }

    public void removeArrows(Set<ArrowWidget> arrowsToRemove) {
        for (ArrowWidget arrow : arrowsToRemove) {
            this.connectionLayer.removeChild((Widget)arrow);
        }
    }

    public void update() {
        this.revalidateBranch((Widget)this.widgetLayer);
        this.validate();
        this.revalidateBranch((Widget)this.connectionLayer);
        for (Widget connectionWidget : this.connectionLayer.getChildren()) {
            ArrowWidget arrow = (ArrowWidget)connectionWidget;
            arrow.reroute();
        }
        this.validate();
        this.repaint();
    }

    private void revalidateBranch(Widget branchRoot) {
        for (Widget child : branchRoot.getChildren()) {
            this.revalidateBranch(child);
        }
        branchRoot.revalidate();
    }

    private String getLayerName(Widget layer) {
        if (layer == this.connectionLayer) {
            return "ConnectionLayer";
        }
        if (layer == this.widgetLayer) {
            return "WidgetLayer";
        }
        if (layer == this.backgroundLayer) {
            return "BackgroundLayer";
        }
        if (layer == this.dragAndDropLayer) {
            return "DragAndDropLayer";
        }
        return "UnknownLayer(" + layer + ")";
    }

    protected void paintChildren() {
        for (Widget child : this.getChildren()) {
            try {
                child.paint();
            }
            catch (AssertionError error) {
                Exceptions.printStackTrace((Throwable)((Object)error));
            }
        }
        ++this.loop;
    }

    private String getArrowInfo() {
        List connectionWidgets = this.connectionLayer.getChildren();
        StringBuilder sb = new StringBuilder("Number of arrows: " + connectionWidgets.size() + '\n');
        int arrowIndex = 0;
        for (Widget connectionWidget : connectionWidgets) {
            ArrowWidget arrow = (ArrowWidget)connectionWidget;
            Widget sourceAnchorWidget = arrow.getSourceAnchor().getRelatedWidget();
            Point sourceAnchorSceneLocation = arrow.getSourceAnchor().getRelatedSceneLocation();
            Widget targetAnchorWidget = arrow.getTargetAnchor().getRelatedWidget();
            Point targetAnchorSceneLocation = arrow.getTargetAnchor().getRelatedSceneLocation();
            String arrowInfo = MessageFormat.format("Arrow {0,number,##}: {1} -> {2};  {3} -> {4}", arrowIndex, sourceAnchorWidget, targetAnchorWidget, sourceAnchorSceneLocation, targetAnchorSceneLocation);
            sb.append(arrowInfo).append('\n');
            ++arrowIndex;
        }
        return sb.toString();
    }

    private String getLayerStructureInfo(LayerWidget layer) {
        StringBuilder sb = new StringBuilder();
        sb.append("Structure of layer ");
        sb.append(this.getLayerName((Widget)layer));
        sb.append('\n');
        sb.append(this.getSubtreeInfo((Widget)layer, 0));
        return sb.toString();
    }

    private String getSubtreeInfo(Widget subroot, int prefixLength) {
        StringBuilder sb = new StringBuilder();
        for (int prefixIndex = 0; prefixIndex < prefixLength; ++prefixIndex) {
            sb.append(' ');
        }
        sb.append(subroot.getClass().getSimpleName());
        sb.append(": ");
        sb.append(subroot);
        sb.append('\n');
        int childPrefixLength = prefixLength + 2;
        for (Widget child : subroot.getChildren()) {
            sb.append(this.getSubtreeInfo(child, childPrefixLength));
        }
        return sb.toString();
    }

    void addDragAndDropWidget(Widget newWidget) {
        this.dragAndDropLayer.addChild(newWidget);
    }

    void removeDragAndDropWidget(Widget widget) {
        this.dragAndDropLayer.removeChild(widget);
    }

    public ShedWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public void setWidgetFactory(ShedWidgetFactory newWidgetFactory) {
        assert (newWidgetFactory.getScene() == this);
        this.widgetFactory = newWidgetFactory;
    }
}

