/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.view;

import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.pogamut.posh.PoshDataObject;
import cz.cuni.pogamut.posh.explorer.PalettePane;
import cz.cuni.pogamut.shed.view.TreeModificationListener;
import cz.cuni.pogamut.shed.widget.LapSceneFactory;
import cz.cuni.pogamut.shed.widget.ShedScene;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

final class LapTreeMVElement
extends JSplitPane
implements MultiViewElement {
    private final JToolBar toolbar;
    private MultiViewElementCallback callback;
    private final PoshDataObject dObj;
    private final PoshPlan lapTree;
    private final ShedScene scene;
    private static final String DEFAULT_DC_NAME = "life";
    private final TreeModificationListener saveListener;
    private final ShedUndoRedo undoRedo;
    private final JScrollPane sceneScrollPane;
    private final PalettePane explorer;

    LapTreeMVElement(PoshDataObject dObj) {
        super(1);
        this.dObj = dObj;
        this.lapTree = LapElementsFactory.createPlan((String)DEFAULT_DC_NAME);
        this.undoRedo = new ShedUndoRedo(50);
        this.saveListener = new TreeModificationListener(this.lapTree, dObj.getEditorSupport().getDocument(), this.undoRedo);
        this.scene = LapSceneFactory.createShedScene(this.lapTree);
        this.toolbar = this.createToolbarRepresentation();
        this.sceneScrollPane = new JScrollPane();
        this.sceneScrollPane.setViewportView(this.scene.createView());
        this.scene.getView().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JComponent view = LapTreeMVElement.this.scene.getView();
                if (!view.isFocusOwner()) {
                    view.requestFocusInWindow();
                }
            }
        });
        this.setLeftComponent(this.sceneScrollPane);
        this.explorer = new PalettePane(this.lapTree, this.getProject(), this.scene.getPresenter());
        this.explorer.setPreferredSize(new Dimension(300, 1024));
        this.setRightComponent(this.explorer);
        this.scene.setPaletteActions(this.explorer);
        this.setResizeWeight(1.0);
    }

    private Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)this.dObj.getPrimaryFile());
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        return this.toolbar;
    }

    public Action[] getActions() {
        if (this.callback != null) {
            return this.callback.createDefaultActions();
        }
        return new Action[0];
    }

    public Lookup getLookup() {
        return this.dObj.getNodeDelegate().getLookup();
    }

    public void componentOpened() {
        this.saveListener.register();
    }

    public void componentShowing() {
        PoshPlan documentLapTree;
        try {
            documentLapTree = this.dObj.parseLapPlan();
        }
        catch (ParseException ex) {
            this.sceneScrollPane.setViewportView(new JTextField(ex.getMessage()));
            return;
        }
        this.sceneScrollPane.setViewportView(this.scene.getView());
        if (!this.saveListener.isModified()) {
            this.saveListener.setEnabled(false);
            this.lapTree.synchronize(documentLapTree);
            this.saveListener.setEnabled(true);
        } else {
            this.lapTree.synchronize(documentLapTree);
        }
        this.scene.update();
        this.explorer.refresh();
    }

    public void componentClosed() {
        this.saveListener.unregister();
    }

    public void componentHidden() {
    }

    public void componentActivated() {
        this.scene.getView().requestFocusInWindow();
    }

    public void componentDeactivated() {
    }

    public UndoRedo getUndoRedo() {
        return this.undoRedo;
    }

    public void setMultiViewCallback(MultiViewElementCallback mvec) {
        this.callback = mvec;
    }

    public CloseOperationState canCloseElement() {
        if (this.dObj.isModified()) {
            AbstractAction saveAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LapTreeMVElement.this.dObj.getEditorSupport().saveDocument();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            AbstractAction discardAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LapTreeMVElement.this.dObj.getEditorSupport().onCloseDiscard();
                }
            };
            String messageSave = this.dObj.getEditorSupport().messageSave();
            return MultiViewFactory.createUnsafeCloseState((String)messageSave, (Action)saveAction, (Action)discardAction);
        }
        return CloseOperationState.STATE_OK;
    }

    private JToolBar createToolbarRepresentation() {
        JToolBar tb = new JToolBar();
        tb.add(new AbstractAction("Create sense"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotifyDescriptor.InputLine desc = new NotifyDescriptor.InputLine("Get name of sense", "Add new sense to goal od DC");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                if (desc.getValue() != NotifyDescriptor.OK_OPTION) {
                    return;
                }
                LapTreeMVElement.this.lapTree.getDriveCollection().getGoal().add(LapElementsFactory.createSense((String)desc.getInputText()));
            }
        });
        return tb;
    }

    class ShedUndoRedo
    implements UndoRedo {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final int historySize;
        private final List<String> history;
        private int position;
        private boolean ignore = false;

        ShedUndoRedo(int steps) {
            this.historySize = steps;
            this.history = new ArrayList<String>(steps);
            this.position = -1;
        }

        public void add(String plan) {
            boolean isPositionAtLastElement;
            if (this.ignore) {
                return;
            }
            boolean bl = isPositionAtLastElement = this.position == this.history.size() - 1;
            if (!isPositionAtLastElement) {
                this.history.subList(this.position + 1, this.history.size()).clear();
            }
            this.history.add(plan);
            while (this.history.size() > this.historySize) {
                this.history.remove(0);
            }
            this.position = this.history.size() - 1;
            this.cs.fireChange();
        }

        public boolean canUndo() {
            return !this.history.isEmpty() && this.position > 0;
        }

        public boolean canRedo() {
            return !this.history.isEmpty() && this.position < this.history.size() - 1;
        }

        public void undo() throws CannotUndoException {
            try {
                this.ignore = true;
                String planText = this.history.get(this.position - 1);
                PoshParser parser = new PoshParser((Reader)new StringReader(planText));
                PoshPlan plan = parser.parsePlan();
                LapTreeMVElement.this.lapTree.synchronize(plan);
                if (this.position > 0) {
                    --this.position;
                }
            }
            catch (ParseException ex) {
                throw new CannotUndoException();
            }
            finally {
                this.ignore = false;
                this.cs.fireChange();
            }
        }

        public void redo() throws CannotRedoException {
            try {
                this.ignore = true;
                String planText = this.history.get(this.position + 1);
                PoshParser parser = new PoshParser((Reader)new StringReader(planText));
                PoshPlan plan = parser.parsePlan();
                LapTreeMVElement.this.lapTree.synchronize(plan);
                if (this.position < this.history.size() - 1) {
                    ++this.position;
                }
            }
            catch (ParseException ex) {
                throw new CannotRedoException();
            }
            finally {
                this.ignore = false;
                this.cs.fireChange();
            }
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }
    }
}

