/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.TableArgumentFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ArgumentsTableModel
extends AbstractTableModel {
    static final String[] columns = new String[]{"Argument name", "Value"};
    final List<TableArgument> arguments;
    final boolean areNamesEditable;

    ArgumentsTableModel(List<TableArgument> modelArgs, boolean areArgNamesEditable) {
        this.arguments = new ArrayList<TableArgument>(modelArgs);
        this.areNamesEditable = areArgNamesEditable;
    }

    @Override
    public final int getColumnCount() {
        return columns.length;
    }

    @Override
    public final String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public final int getRowCount() {
        return this.arguments.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.areNamesEditable;
            }
            case 1: {
                return true;
            }
        }
        throw new FubarException("Column " + columnIndex);
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.arguments.get(rowIndex).getName();
        }
        if (columnIndex == 1) {
            return this.arguments.get(rowIndex).getValueString();
        }
        throw new FubarException("Unexpected column index " + columnIndex);
    }

    @Override
    public final void setValueAt(Object value, int rowIndex, int columnIndex) {
        TableArgument argument = this.arguments.get(rowIndex);
        String valueString = (String)value;
        if (columnIndex == 0) {
            argument.setName(valueString);
        } else if (columnIndex == 1) {
            if (valueString.isEmpty()) {
                argument.setValueBlank();
            } else {
                try {
                    argument.setValueString(valueString);
                }
                catch (ParseException ex) {
                    return;
                }
            }
        } else {
            throw new FubarException("Unexpected position " + rowIndex + " " + columnIndex);
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public final void deleteArgument(int deleteIndex) {
        this.arguments.remove(deleteIndex);
        this.fireTableRowsDeleted(deleteIndex, deleteIndex);
    }

    public final void addArgument(int addIndex, String argName, Object value) {
        TableArgument newVariable = TableArgumentFactory.createArgWithValue(argName, value);
        this.arguments.add(addIndex, newVariable);
        this.fireTableDataChanged();
    }

    public final void addVariableArgument(int addIndex, String argName, String variableName) {
        TableArgument newVariable = TableArgumentFactory.createFromArgument(Arguments.Argument.createVariableArgument((String)argName, (String)variableName));
        this.arguments.add(addIndex, newVariable);
        this.fireTableDataChanged();
    }

    public List<TableArgument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }
}

