/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.pogamut.shed.presenter.AbstractAcceptAction;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedWidget;
import cz.cuni.pogamut.shed.widget.ShedWidgetFactory;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.widget.Widget;

class DragAndDropMoveProvider<LAP_ELEMENT extends PoshElement>
implements MoveProvider {
    private static final Color GHOST_IS_ACCEPTED_COLOR = Color.GREEN;
    private static final Color GHOST_IS_NOT_ACCEPTED_COLOR = Color.RED;
    private final ShedScene scene;
    private final ShedWidget sourceWidget;
    private final LAP_ELEMENT element;
    private ShedWidget ghostWidget;

    DragAndDropMoveProvider(ShedScene scene, ShedWidget sourceWidget, LAP_ELEMENT element) {
        this.scene = scene;
        this.sourceWidget = sourceWidget;
        this.element = element;
    }

    public Point getOriginalLocation(Widget widget) {
        Point sourceWidgetLeftTopCorner = new Point();
        Point sceneLocation = this.sourceWidget.convertLocalToScene(sourceWidgetLeftTopCorner);
        return sceneLocation;
    }

    public void movementStarted(Widget widget) {
        this.ghostWidget = ShedWidgetFactory.createWidgetCopy(this.sourceWidget);
        this.ghostWidget.setPreferredLocation(this.getOriginalLocation(widget));
        this.scene.addDragAndDropWidget(this.ghostWidget);
    }

    public void setNewLocation(Widget widget, Point point) {
        this.ghostWidget.setPreferredLocation(point);
        if (this.canBeElementDropped()) {
            this.ghostWidget.setBorderColor(GHOST_IS_ACCEPTED_COLOR);
        } else {
            this.ghostWidget.setBorderColor(GHOST_IS_NOT_ACCEPTED_COLOR);
        }
    }

    private boolean canBeElementDropped() {
        return this.getTargetAcceptAction() != null;
    }

    private AbstractAcceptAction getTargetAcceptAction() {
        Point sceneCenter = this.getGhostSceneCenter();
        ShedWidget foundWidget = this.scene.findShedWidget(sceneCenter);
        if (foundWidget == null) {
            return null;
        }
        if (foundWidget == this.sourceWidget) {
            return null;
        }
        DataFlavor sourceDataFlavor = this.element.getDataFlavor();
        IPresenter targetWidgetPresenter = foundWidget.getPresenter();
        AbstractAcceptAction[] targetAcceptActions = targetWidgetPresenter.getAcceptProviders();
        if (targetAcceptActions == null) {
            return null;
        }
        for (AbstractAcceptAction targetAcceptAction : targetAcceptActions) {
            DataFlavor targetDataFlavor = targetAcceptAction.getDataFlavor();
            if (!targetDataFlavor.equals(sourceDataFlavor)) continue;
            return targetAcceptAction;
        }
        return null;
    }

    public void movementFinished(Widget widget) {
        this.scene.removeDragAndDropWidget(this.ghostWidget);
        AbstractAcceptAction targetAcceptAction = this.getTargetAcceptAction();
        if (targetAcceptAction != null) {
            targetAcceptAction.performAction(this.element);
        }
        this.ghostWidget = null;
    }

    private Point getGhostSceneCenter() {
        Rectangle ghostBounds = this.ghostWidget.getBounds();
        Rectangle sceneBounds = this.sourceWidget.convertLocalToScene(ghostBounds);
        Point ghostSceneLocation = this.ghostWidget.getLocation();
        int x = ghostSceneLocation.x + sceneBounds.width / 2;
        int y = ghostSceneLocation.y + sceneBounds.height / 2;
        return new Point(x, y);
    }
}

