/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.editor.ActionEditor;
import cz.cuni.pogamut.shed.widget.editor.ShedEditorProvider;
import java.text.MessageFormat;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.widget.Widget;

final class ActionEditorProvider
extends ShedEditorProvider<TriggeredAction, ActionEditor> {
    private final ShedPresenter presenter;

    public ActionEditorProvider(TriggeredAction primitive, ShedPresenter presenter, LapChain chain) {
        super(primitive, chain);
        this.presenter = presenter;
    }

    public void notifyClosing(InplaceEditorProvider.EditorController ec, Widget widget, ActionEditor editor, boolean commit) {
        if (commit) {
            String newName;
            String oldName = ((TriggeredAction)this.node).getName();
            if (!oldName.equals(newName = editor.getActionName())) {
                String errorMessage;
                try {
                    ((TriggeredAction)this.node).setActionName(newName);
                }
                catch (InvalidNameException ex) {
                    errorMessage = MessageFormat.format("Name \"{0}\" is not valid", newName);
                    this.notify(errorMessage);
                }
                catch (CycleException ex) {
                    errorMessage = MessageFormat.format("Changing name to \"{0}\" would cause a cycle.", newName);
                    this.notify(errorMessage);
                }
            }
            Arguments args = new Arguments();
            String unsuccessfull = this.convertEditorArg(editor.getArguments(), args);
            if (!unsuccessfull.isEmpty()) {
                this.notify("Following arguments had errors: \n" + unsuccessfull);
            }
            ((TriggeredAction)this.node).setArguments(args);
        }
    }

    public ActionEditor createEditorComponent(InplaceEditorProvider.EditorController controller, Widget widget) {
        ParamInfo[] paramNames = this.presenter.getPrimitiveParameters(((TriggeredAction)this.node).getName());
        return new ActionEditor((TriggeredAction)this.node, paramNames, controller, this.chain);
    }
}

